#include "TwoStacksANB.h"

TwoStacksANB::TwoStacksANB(int guaranteedCapacity) {
        elements = new vector<char>(2 * guaranteedCapacity);
        frontItem = guaranteedCapacity; // INVAR Represents the leftmost item of the leftward-growing stack.
        rearSpace = guaranteedCapacity; // INVAR Represents the space right of the rightmost item of the rightward-growing stack.
        upperBound = 2 * guaranteedCapacity; // INVAR This is the number of indexes in the vector we use to store our chars.
}

bool TwoStacksANB::isEmpty() const {return frontItem == rearSpace;}
bool TwoStacksANB::isFull() const {return (frontItem == 0 && rearSpace == upperBound);}
int TwoStacksANB::size() const {return rearSpace - frontItem;}

char TwoStacksANB::popRear() {
    try {
        if (isEmpty()) {
            throw 20;
        } else {
            return elements->at(--rearSpace);
        }
    }
    catch (int e) {
        cerr << "Cannot call popRear() on an empty TwoStacks object." << endl;
    }
}

char TwoStacksANB::popFront() {
    try {
        if (isEmpty()) {
            throw 20;
        } else {
            return elements->at(frontItem++);
        }
    }
    catch (int e) {
        cerr << "Cannot call popFront() on an empty TwoStacks object." << endl;
    }
}

void TwoStacksANB::pushRear(char newItem) {
    try {
        if (frontItem == 0) {
            throw 20;
        } else {
            elements->at(rearSpace++) = newItem;
        }
    }
    catch (int e) {
        cerr << "Rear stack is full; cannot call pushRear()." << endl;
    }
}

void TwoStacksANB::pushFront(char newItem) {
    try {
        if (rearSpace == upperBound) {
            throw 20;
        } else {
            elements->at(--frontItem) = newItem;
        }
    }
    catch (int e) {
        cerr << "Front stack is full; cannot call pushFront()." << endl;
    }
}

string TwoStacksANB::toString() {
    stringstream out;
    for (int i = frontItem; i < rearSpace; i++) {
        out << elements->at(i) << " ";
    }
    return out.str();
}
