#ifndef VALLIANB_H_
#define VALLIANB_H_

#include "DList.h"
#include <vector>

template <typename I>
class Valli {
public:
	class iterator {
		typename DList<I>::iterator list_iter;

		iterator(const typename DList<I>::iterator& l_iter)
            :list_iter(l_iter) {}

		friend class Valli<I>;

	public:
		iterator() {}

		iterator(const iterator& other)
			:list_iter(other.list_iter) {}

		iterator& operator=(const iterator& rhs)
		{
			list_iter = rhs.list_iter;
			return *this;
		}

		I& operator*() const
		{
			return *list_iter;
		}

		iterator& operator++()
		{
			++list_iter;
			return *this;
		}

		iterator& operator--()
		{
			--list_iter;
			return *this;
		}

		iterator operator++(int)
		{
			iterator oldMe = *this;
			list_iter++;
			return oldMe;
		}

		bool operator==(const iterator& rhs) const
		{
			return list_iter == rhs.list_iter;
		}

		bool operator!=(const iterator& rhs) const
		{
			return list_iter != rhs.list_iter;
		}
	};

private:
	DList<I> list;
	std::vector<iterator> vec;
	size_t n, r;

public:
	explicit Valli(size_t ratio = 2)
	{
	    list = DList<I>();
	    vec = std::vector<iterator>();
	    n = 0;
	    r = ratio;
	}

	~Valli() {}

	iterator begin() const
	{
		return iterator(list.begin());
	}

	iterator end() const
	{
		return iterator(list.end());
	}


    iterator find(const I& item) const
        {
                size_t left = 0;
                size_t right = vec.size();

                while (right - left > 1)
                {
                        size_t middle = (left + right)/2;
                        if (item < *vec[middle])
                        {
                            right = middle;
                        }
                        else
                        {
                            left = middle;
                        }
                }

                iterator begin_iter = left < vec.size() ? vec[left] : begin();
                iterator end_iter = right < vec.size() ? vec[right] : end();
                for (iterator iter = begin_iter; iter != end_iter; iter++)
                {
                        if (*iter == item)
                        {
                            return iter;
                        }
                        if (*iter > item)
                        {
                            return end();
                        }
                }

                return end();
        }

    iterator insert(const I& item)
    {
        size_t left = 0;
        size_t right = vec.size();

        while (right - left > 1)
        {
                size_t middle = (left + right) / 2;

                if (item < *vec[middle]) {right = middle;}
                else {left = middle;}
        }

        iterator begin_iter = left < vec.size() ? vec[left] : begin();
        iterator end_iter = right < vec.size() ? vec[right] : end();
        iterator iter = begin_iter;

        for (; iter != end_iter; iter++) {if (*iter >= item) {break;}}

        iterator result = iterator(list.insert(iter.list_iter, item));

        if (vec.empty())
        {
            vec.insert(vec.begin(), iterator(list.begin()));
        }
        else
        {
            vec[0] = iterator(list.begin());
        }

        if (++n > 2 * r * vec.size()) {refresh();}
        return result;
    }

    size_t size() const {return n;}
	bool empty() const {return size() == 0;}
	string str() const {return list.toString();}

	void refresh(size_t newRatio)
	{
		r = newRatio;
		vec.clear();

		size_t count = r;
		for (iterator iter = begin(); iter != end(); iter++, count++)
        {
            if (count == r)
			{
				count = 0;
				vec.push_back(iter);
			}
        }
	}

	void refresh() {refresh(r);}

    void erase(const I& item)
    {
        refresh();
        iterator iter = find(item);
        bool isMilepost = false;

        for(size_t i = 0; i < vec.size(); i++)
        {
            if(vec[i] == iter)
            {
                isMilepost = true;
                vec[i] = ++iter;
                --iter;
                list.erase(iter.list_iter);
            }
        }

        if (isMilepost == false) {list.erase(iter.list_iter);}

        for(size_t i = 0; i < vec.size(); i++)
        {
            cout << *(vec[i]) << endl;
        }
    }
};
#endif

