#include<string>
#include<iostream>
#include<fstream>
#include<vector>
#include "PeekDeque3AJC.h"
#include "StringWrap.h"

using namespace std;

bool ed1(const string& x, const string& y) {
    string longString;
    string shortString;
    int edits = 0;

    if(x.length() <= y.length()) {
        longString = y;
        shortString = x;
    } else {
        longString = x;
        shortString = y;
    }

    for(unsigned int i = 0; i < shortString.length(); i++){
        //LOOP INV: Characters < i have been compared
        if(longString.at(i) != shortString.at(i)) {
            //chars differ at index i
            if(longString.length() != shortString.length()) {
                //Strings have an insertion
                //remove extra char from longer string
                longString.erase(i, 1);
                if(longString.at(i) != shortString.at(i)) {
                    edits++;
                }
            }
            edits++;
        }
    }

    //Strings have passed all tests if edits is 0 or 1
    return edits <= 1;
}

int main(int argc, char** argv) {
    //Check for proper input
    if(argc != 2) {
        cerr << "Inproper arguments!  Usage is: " << argv[0] << " <filename>" << endl;
        return 0;
    }

    ifstream file(argv[1]);
    if(!file) {
        cerr << "Unable to open file \"" << argv[1] << "\"" << endl;
        return 1;
    }


    vector<PeekDeque<string>* > chainVector = vector<PeekDeque<string>* >();

    string data;
    StringWrap dataWrap;
    if(!(file >> data)){
        cout << "File \"" << argv[1] << "\" is empty" << endl;
        return 0;
    }
    dataWrap = StringWrap(data);
    dataWrap.trimNonAlpha();
    dataWrap.makeLower();
    chainVector.push_back(new PeekDeque<string>(100));
    
    data = dataWrap.str();
    chainVector.at(0)->pushRear(data);

    bool sorted;
    while(file >> data) {

        dataWrap = StringWrap(data);
        dataWrap.trimNonAlpha();
        dataWrap.makeLower();
        data = dataWrap.str();
        
        //Compare to all current chains
        sorted = false;
        cout << chainVector.size() << endl;
        for(int i = 0; i < chainVector.size(); i++) {
            chainVector.at(i)->moveToFront();
            if(ed1(chainVector.at(i)->peek(), data)) {
                chainVector.at(i)->pushFront(data);
                sorted = true;
                break;
            }
            
            chainVector.at(i)->moveToRear();
            if(ed1(chainVector.at(i)->peek(), data)) {
                chainVector.at(i)->pushRear(data);
                sorted = true;
                break;
            }
            cout << "debug" << endl;
        }
        
        if(!sorted) {
            //add new chain
            PeekDeque<string>* chain = new PeekDeque<string>(100);
            chain->pushRear(data);
            chainVector.push_back(chain);
        }

    }

    file.close();

    return 0;
}
/*
 * This code is not entirely functional, but the general theory of what it should do is present.
 * The chains it would create would not prevent repetition of words, and would probably result in 
 * chains that flop back and forth between a limited number of words.
 */
    
