/** File "FlexArray2AJC.h", by AJC. Spring 2014
    Templated Data-structure file for Project 1.  Need to add:
    (*) Iterator class---in labs from April 8 to 11
    (*) Methods T at(int j), iterator insert(iterator pos, const T& newItem), 
        iterator erase(iterator pos) due on April 14
    (*) Project with expanded client due Mon. April 21.
 */

#ifndef _FLEXARRAY_H_
#define _FLEXARRAY_H_

#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>
#include <exception>
#include <stdexcept>

using std::vector;
using std::endl;
using std::cerr;
using std::ostringstream;
using std::runtime_error;
using std::string;


template <typename T>    //REQ: T has T() and T.str()
class FlexArray;

//template <typename T>
//class FlexArray::iterator;

template <typename T>
class ChunkNode {
   vector<T>* elements;

   ChunkNode<T>* next;       //typename is illegal here
   ChunkNode<T>* prev;

   size_t mySize;            //INV: # of elements actually stored
   friend class FlexArray<T>;
   friend class FlexArray<T>::iterator;   //begin lab with this line

 public:
   ChunkNode<T>(ChunkNode<T>* myNext, ChunkNode<T>* myPrev)
    : elements(new vector<T>()), next(myNext), prev(myPrev), mySize(0)
   { }
};

template <class T>
class FlexArray {
   ChunkNode<T>* firstNode;
   ChunkNode<T>* endNode;
   size_t nodeCap;
   size_t numNodes;
   //friend class ChunkNode<T>;   //IMHO not necessary

   //CLASS INV: endNode is a dummy node, used as target for iterations.
   //firstNode is a real node only when the FlexArray is nonempty (Optional change)
   //Empty is size() == 0, rather than endNode == firstNode.
   //Note: for empty FlexArray, rbegin() cannot assume endNode->prev is
   //non-NULL.  For empty FlexArray, both begin() and rbegin() should == end()
   //MOST IMPT: every non-dummy node is nonempty---empty elements means de-allocate node.

 public:
      
   explicit FlexArray<T>(size_t nodeCap) 
    : firstNode(new ChunkNode<T>(NULL, NULL))
    , endNode(firstNode)
    , nodeCap(nodeCap)
    , numNodes(1)
   { }

   FlexArray<T>()
    : firstNode(new ChunkNode<T>(NULL,NULL))
    , endNode(firstNode)
    , nodeCap(40)
    , numNodes(1)
   { }
                       
   class iterator {           //does not need "template <typename T>" since nested
      FlexArray<T>* myList;   //CANNOT see (non-static) fields of FlexArray directly.
      ChunkNode<T>* node;     //Hence having a "myList" field might be a good idea.
      size_t localIndex;

      friend class FlexArray<T>;

      iterator(FlexArray<T>* myList, ChunkNode<T>* node, size_t li)
         : myList(myList)
         , node(node)
         , localIndex(li)
      { }

      public:

      //Need to impliment *(dereference), ++(pre and post), ==, !=, >=, <=

      T& operator*() {
         if(node == NULL || node == myList->endNode) {
            cerr << "Attempt to derefrence null element!" << endl;
            return new T();
         }
         return node->elements->at(localIndex);
      }

      iterator& operator++() {
         //pre
         if(node == NULL || node == myList->endNode) {
            cerr << "Attempt to increment past list end!" << endl;
         }

         localIndex++;
         if(localIndex == node->elements->size()) {
            node = node->next;
            localIndex = 0;
         }

         return *this;
      }

      iterator operator++(int ignored) {
         //post
         iterator copy = *this;

         operator++();
         return copy;
      }

      bool operator==(const iterator& rhs) const {
         return node == rhs.node && localIndex == rhs.localIndex && myList == rhs.myList;
      }

      bool operator!=(const iterator& rhs) const {
         return (*this == rhs);
      }

   }; 

   //-----------------------
   //END ITERATOR DEFINITION
   //-----------------------

   iterator begin() {
      return iterator(this, firstNode, 0);
   }

   iterator end() {
      return iterator(this, endNode, 0);
   }

   iterator rbegin() {
      return iterator(this, endNode->prev, endNode->prev->elements->size() - 1);
   }

   //at, insert, erase, operator[] etc. methods go here...
   
   T& at(size_t index) const {
      if(empty()) {
          cerr << "Attempt to call at() or operator[] on empty FlexArray!" << endl;
          return T();
      }

      ChunkNode<T>* curNode = firstNode;
      while(index >= curNode->size()) {  //index is past this node
        if(curNode == endNode) {
            cerr << "Index out of range!" << endl;
            return T();
        }

        index -= curNode->size();
        curNode = curNode->next();
      }

      //Node found
      return curNode->elements->at(index);
   }

   T& operator[](size_t index) const {
       return at(index);
   }

   bool empty() const {
       return size() == 0;
   }

   size_t size() const {
        int count = 0;
        ChunkNode<T>* curNode = firstNode;
        for(int i = 0; i < numNodes; i++) {
            count += curNode->elements->size();
            curNode = curNode->next;
        }
        return count;
   }

   /*Inserts new item in front of iter
    * returns iterator to new item
    */
   iterator insert(iterator iter, const T& item) {
      if(firstNode == endNode) { //Need to insert new firstNode, iter is still valid on endNode
         firstNode = new ChunkNode<T>(endNode, NULL);
         endNode->prev = firstNode;
         numNodes++;
         //Insert new item into frontNode
         firstNode->elements->push_back(item);
         cerr << "INSERTING FIRST NODE" << endl;
         return begin();
         //No need to split because there is only one item
      }

      if(iter.node == endNode) {
         //Insert into last real node
         endNode->prev->elements->push_back(item);
         if(endNode->prev->elements->size() == nodeCap) {
            split(endNode->prev);
         }
         return iterator(this, endNode->prev, endNode->prev->elements->size() - 1);
      }

      //Insert into current node (Normal case)
      iter.node->elements->insert(iter.node->elements->begin() + iter.localIndex, item);
      //Need to increment localIndex because it now points to the newly inserted item
      iter.localIndex++;

      //check to see if we need to split the node
      if(iter.node->elements->size() == nodeCap) {
         split(iter.node);

         if(iter.localIndex >= nodeCap/2) { //localIndex is past split point, move iter
            iter.node = iter.node->next;
            iter.localIndex -= nodeCap/2;
         }

         if(iter.localIndex = 0) { //we've moved to the beginning of a node.  Return end of last node
            return iterator(this, iter.node->prev, iter.node->prev->elements->size() - 1);
         }
      }

      //If we got this far, we're in the proper node to return
      return iterator(this, iter.node, iter.localIndex - 1);

   }

   iterator erase(iterator iter) {
      if(iter.node == endNode) {
         cerr << "Unable to delete end()" << endl;
         return end();
      }

      iterator newIterator;
      if(iter.localIndex == iter.node->elements->size() - 1) { 
         //will delete end of node, return iterator to next node
         newIterator = iterator(this, iter.node->next, 0);
      } else {
         //Staying in same node
         newIterator = iterator(this, iter.node, iter.localIndex); //Keep localIndex, it now represents next item
      }

      //If we're empty, remove head and make firstNode == endNode
   }

   string toString() {
      ostringstream out;
      iterator iter = begin();
      while(iter != end()) {
         //cerr << iter.node->elements->size();
         out << iter.node->elements->at(iter.localIndex) << " ";
         iter++;
      }
      return out.str();
   }

   private:

   void split(ChunkNode<T>* node) {
      ChunkNode<T>* newNode = new ChunkNode<T>(node->next, node);
      node->next->prev = newNode;
      node->next = newNode;

      for(int i = nodeCap/2; i < nodeCap; i++) {
         newNode->elements->push_back(node->elements->at(i));
      }
      
      for(int i = nodeCap - 1; i >= nodeCap/2; i++) {
         node->elements->erase(node->elements->begin() + i);
      }
   }

};

#endif//_FLEXARRAY_H_

