/*FlexClientAJC.cpp by AJC for Spring 2014
 *
 * I had some large problems getting my FlexArray to work properly, but the code for it is included in the submission.
 * The chain builder was not modified to use FlexArray, but the questions were answered to the best of my ability.
 */

#include<string>
#include<iostream>
#include<fstream>
#include<vector>
#include "PeekDeque3AJC.h"
#include "StringWrap.h"

using namespace std;

bool ed1(const string& x, const string& y) {
    string longString;
    string shortString;
    int edits = 0;
    
    //cout << "String x: " << x << "\t String y: " << y << endl;

    if(x.compare(y) == 0) { return false; } //Strings are same.  Will lead to chains of a single word

    if(x.length() <= y.length()) {
        longString = y;
        shortString = x;
    } else {
        longString = x;
        shortString = y;
    }

    if(longString.length() - shortString.length() > 1) { return false; }

    for(unsigned int i = 0; i < shortString.length(); i++){
        //LOOP INV: Characters < i have been compared
        if(longString.at(i) != shortString.at(i)) {
            //chars differ at index i
            if(longString.length() != shortString.length()) {
                //Strings have an insertion
                //remove extra char from longer string
                longString.erase(i, 1);
                if(longString.at(i) != shortString.at(i)) {
                    edits++;
                }
            }
            edits++;
        }
    }

    //Strings have passed all tests if edits is 0 or 1
    return edits <= 1;
}

int main(int argc, char** argv) {
    //Check for proper input
    if(argc != 2) {
        cerr << "Inproper arguments!  Usage is: " << argv[0] << " <filename>" << endl;
        return 0;
    }

    ifstream file(argv[1]);
    if(!file) {
        cerr << "Unable to open file \"" << argv[1] << "\"" << endl;
        return 1;
    }


    vector<PeekDeque<StringWrap>* > chainVector = vector<PeekDeque<StringWrap>* >();

    string data;
    StringWrap dataWrap;
    if(!(file >> data)){
        cout << "File \"" << argv[1] << "\" is empty" << endl;
        return 0;
    }
    dataWrap = StringWrap(data);
    dataWrap.trimNonAlpha();
    dataWrap.makeLower();
    chainVector.push_back(new PeekDeque<StringWrap>(1000));
    
    chainVector.at(0)->pushRear(dataWrap);

    //REMOVE ALL BELOW THIS
    
    cout << chainVector.at(0)->toString() << endl;
    
    //REMOVE ALL ABOVE THIS
    
    while(file >> data) {   //Loop over entire file
        dataWrap = StringWrap(data);
        dataWrap.trimNonAlpha();
        dataWrap.makeLower();           //dataWrap now contains new string to add

        if(dataWrap.str() == "") {
            //String is now empty.  Skip it
            continue;
        }


        //Compare to all current chains
        bool sorted = false;
        for(int i = 0; i < chainVector.size(); i++) {
            //Compare front
            chainVector.at(i)->moveToFront();
            if(ed1(chainVector.at(i)->peek().str(), dataWrap.str())) {
                   //Front match
                   chainVector.at(i)->pushFront(dataWrap);
                   //cout << "FRONT " << dataWrap.str() << " ed1 " << chainVector.at(i)->peek().str() << endl;
                   sorted = true;
                   break;
            } 

            //Compare back
            chainVector.at(i)->moveToRear();
            if(ed1(chainVector.at(i)->peek().str(), dataWrap.str())) {
                   //Back match
                   chainVector.at(i)->pushRear(dataWrap);
                   //cout << "REAR  " << dataWrap.str() << " ed1 " << chainVector.at(i)->peek().str() << endl;
                   sorted = true;
                   break;
            } 
            
        } //End compare block

        if(!sorted) { //dataWrap was not taken care of.  Make new chain
            //cout << "Adding new chain for " << dataWrap.str() << "! " << endl;
            chainVector.push_back(new PeekDeque<StringWrap>(1000));
            chainVector.at(chainVector.size() - 1)->pushRear(dataWrap);
            cout << "Size is now " << chainVector.size() << "!" << endl;
        }
    }

    //All chains are made
    //Time for statistics!

    PeekDeque<StringWrap>* longestChain = new PeekDeque<StringWrap>(1);

    for(int i = 0; i < chainVector.size(); i++) {
        if(chainVector.at(i)->size() > longestChain->size()) {
            longestChain = chainVector.at(i);
        }
    }

    cout << "Longest chain is " << longestChain->size() << " words long!" << endl;
    cout << "It's contents are: " << longestChain->toString() << endl;

    cout << "All Chains:" << endl;

    for(int i = 0; i < chainVector.size(); i++) {
        cout << chainVector.at(i)->toString() << " END" << endl;
    }



    file.close();

    return 0;
}
/*
 * 1) Using iterators would have made implementing the chain building much easier.  I could use two iterators on the same FlexArray to compare two 
 * ajacent words in a chain, instead of having to use the mofeFrontward() and moveRearward() functions in a (relatively) complicated loop.  When
 * searching for the longest chain and best growth chain, I could use iterators to keep tabs as I'm searching for the proper chains.  It would
 * probably help a bit, but too much the way I would implement it.
 *
 * 2) I'm not too sure if doing this would slow down my program at all.  On one hand, adding new chains would be less expensive of an operation
 * for really big documents (like Hamlet.txt), but using a doubly linked list as part of the data structure has a speed cost associated with it.  
 * I'm not sure which would affect my implementation more.
 */
    
