/* MovieAJC.h by AJC for project 2
*  Movie object is a container for a single movie
*/

#ifndef MOVIE_H_
#define MOVIE_H_

#include<string>
#include<iostream>

using std::string;

class Movie {
public:
    enum GenreType {
        GENRE_ACTION = 1,
        GENRE_NOIR = 2,
        GENRE_LIGHT = 4,
        GENRE_SERIOUS = 8,
        GENRE_FANTASY = 16,
        GENRE_HISTORY = 32,
        GENRE_UNKNOWN = 64
    };

    size_t id;
    string title;
    size_t year;
    size_t genre;

    /*  Constructs a new Movie object.
     *  genre is a bitfield of possible genres.
     *  Example usage: Movie(0, "Example Name", 2011, GENRE_LIGHT|GENRE_FANASY);
     */
    Movie(size_t id, string title, size_t year, size_t genre);
    ~Movie();

    /*  Checks to see if a given genre is included in a movie
     *
     */
    bool containsGenre(GenreType genre);
};

#endif // MOVIE_H_
