/* MovieBaseAJC.cpp by AJC for project 2
*  MovieBase is responsible for containing all movies
*/

#include "MovieBaseAJC.h"

using std::pair;
using std::make_pair;

using std::getline;

using std::cerr;
using std::endl;

size_t MovieBase::getSize() {
    return movies.size();
}

vector<string> MovieBase::parseData(string data) {
    vector<string> returnData;
    int lastIndex = 0;
    int index = 0;
    for(int i = 0; i < 24; i++) {
        //Find next colon
        index = data.find("|", lastIndex);
        returnData.push_back(data.substr(lastIndex, index - lastIndex));
        lastIndex = index+1;
    }
    return returnData;
}

void MovieBase::addMovie(Movie movie) {
    movies.insert(make_pair(movie.id, movie));
}

void MovieBase::processMovies(string filename) {
    ifstream file;
    file.open(filename.c_str());
    if(file.fail()) {
        cerr << "Unable to read file " << filename << endl;
    }

    string line;
    vector<string> data;
    size_t genre = 0;

    while(getline(file, line)) {
        //Recurse over file and read contents
        //getline(file, line);
        data = parseData(line);
        /* data now contains movie data.
        ** indexes:
        ** 0:id, 1:name, 2:date(dirty), 3:blank, 4:url, 5-23:genre
        */
        if(data.at(5) == "1") {genre |= Movie::GENRE_UNKNOWN;}
        if(data.at(6) == "1") {genre |= Movie::GENRE_ACTION;}
        if(data.at(7) == "1") {genre |= Movie::GENRE_ACTION;}
        if(data.at(8) == "1") {genre |= Movie::GENRE_LIGHT;}
        if(data.at(9) == "1") {genre |= Movie::GENRE_LIGHT;}
        if(data.at(10) == "1") {genre |= Movie::GENRE_LIGHT;}
        if(data.at(11) == "1") {genre |= Movie::GENRE_NOIR;}
        if(data.at(12) == "1") {genre |= Movie::GENRE_HISTORY;}
        if(data.at(13) == "1") {genre |= Movie::GENRE_SERIOUS;}
        if(data.at(14) == "1") {genre |= Movie::GENRE_FANTASY;}
        if(data.at(15) == "1") {genre |= Movie::GENRE_NOIR;}
        if(data.at(16) == "1") {genre |= Movie::GENRE_NOIR;}
        if(data.at(17) == "1") {genre |= Movie::GENRE_LIGHT;}
        if(data.at(18) == "1") {genre |= Movie::GENRE_NOIR;}
        if(data.at(19) == "1") {genre |= Movie::GENRE_SERIOUS;}
        if(data.at(20) == "1") {genre |= Movie::GENRE_FANTASY;}
        if(data.at(21) == "1") {genre |= Movie::GENRE_ACTION;}
        if(data.at(22) == "1") {genre |= Movie::GENRE_HISTORY;}
        if(data.at(23) == "1") {genre |= Movie::GENRE_ACTION;}
        //Genre now contains the proper flags

        int id;
        stringstream(data.at(0)) >> id;

        int date;
        if(data.at(2) != "") {
            stringstream(data.at(2).substr(7, 4)) >> date;
        } else {
            date = 0;
        }

        addMovie(Movie(id, data.at(1), date, genre));
        genre = 0;
    }
}

Movie MovieBase::getMovie(size_t id) {
    return movies.at(id);
}

vector<Movie>* MovieBase::getGenre(Movie::GenreType genre) {
    vector<Movie>* returnList = new vector<Movie>();

    for(map<size_t, Movie>::iterator it = movies.begin(); it != movies.end(); it++) {
        if(it->second.containsGenre(genre)) {
            returnList->push_back(it->second);
        }
    }

    return returnList;
}

vector<Movie>* MovieBase::getGenre(int genre) {
    Movie::GenreType genreType;
    switch(genre) {
    case 0:
        genreType = Movie::GENRE_UNKNOWN;
        break;

    case 1:
        genreType = Movie::GENRE_ACTION;
        break;

    case 2:
        genreType = Movie::GENRE_NOIR;
        break;

    case 3:
        genreType = Movie::GENRE_LIGHT;
        break;

    case 4:
        genreType = Movie::GENRE_SERIOUS;
        break;

    case 5:
        genreType = Movie::GENRE_FANTASY;
        break;

    case 6:
        genreType = Movie::GENRE_HISTORY;
    }

    return getGenre(genreType);
}

vector<size_t> MovieBase::getGenresOfMovie(size_t id) {
    vector<size_t> returnList = vector<size_t>();
    Movie movie = getMovie(id);
    for(int i = 0; i < 7; i++) {
        if((movie.genre & 1<<i) != 0) {
            if(i == 6) {
                returnList.push_back(0);
            } else {
                returnList.push_back(i+1);
            }
        }
    }
    return returnList;
}

void MovieBase::setGenreAverage(int genre, float average) {
    genreAverages.at(genre) = average;
}

float MovieBase::getGenreAverage(int genre) {
    return genreAverages.at(genre);
}
