/* MovieAJC.h by AJC for project 2
*  MovieBase is responsible for managing all movie objects
*/

#ifndef MOVIEBASE_H_
#define MOVIEBASE_H_

#include<vector>
#include<string>
#include<map>
#include<iostream>
#include<fstream>
#include<utility>
#include<string>
#include<sstream>
#include "MovieAJC.h"

using std::map;
using std::vector;
using std::ifstream;
using std::stringstream;

class MovieBase {
private:


    vector<float> genreAverages;

    /* Parses a single line of data
    */
    vector<string> parseData(string data);

    /* Add a movie to the database
    */
    void addMovie(Movie movie);

public:
    map<size_t, Movie> movies;

    MovieBase()
        :genreAverages(vector<float>(7))
        {}
    ~MovieBase(){}
    /* Returns the number of movies in the database
    */
    size_t getSize();

    /* Parse the u.data file and
    ** create movie objects to represent them
    */
    void processMovies(string filename);

    /* Returns the single movie with the given id
    ** Will return an empty movie object of id was not found
    */
    Movie getMovie(size_t id);

    /* Returns all the movies contained in the given genre
    ** Will return an empty vector if no movies were found in the genre
    */
    vector<Movie>* getGenre(Movie::GenreType genre);
    vector<Movie>* getGenre(int genre);

    /* Returns the genres of a single movie
    ** 0:UNKNOWN, 1:ACTION, 2:NOIR, 3:LIGHT, 4:SERIOUS, 5:FANTASY, 6:HISTORY
    */
    vector<size_t> getGenresOfMovie(size_t id);

    /* Sets the average rating for a specific genre
    ** Used by the client
    */
    void setGenreAverage(int genre, float average);

    /* Returns the average rating for a specific genre
    ** Must call setGenreAverage before using this
    */
    float getGenreAverage(int genre);

};

#endif // MOVIEBASE_H_
