/** File "PeekDeque2AJC.h", by AJC.
Header for PeekDeque class
 */
#ifndef PEEK_DEQUE_H_
#define PEEK_DEQUE_H_

#include<vector>
#include<string>

using namespace std;

class StringDeque
{
protected:
    vector<string>* elements;
    int frontItem;   //CLASS INV: indexes item with least index
    int rearSpace;   //CLASS INV: indexes space after item with greatest index
    int upperBound;  //For array[0..n-1] this is "n" not "n-1".

    //CLASS INV: frontSpace indicates first empty cell for pushFront
    //           rearSpace designates rear item (not space) for popRear---
    //           ---or if there is no such item, rearSpace == frontItem;
public:
    StringDeque(int guaranteedCapacity);

    ~StringDeque();

    virtual bool empty() const;
    virtual bool full() const;
    virtual int size() const;

    virtual string popRear();
    virtual string popFront();

    virtual void pushFront(string newItem);
    virtual void pushRear(string newItem);

    virtual string toString();
};

class PeekDeque : public StringDeque {
    int peekIndex;

public:
    PeekDeque(int guaranteedCapacity);

    virtual bool moveFrontward();
    virtual bool moveRearward();

    virtual void moveToFront();
    virtual void moveToRear();

    virtual string peek();
    virtual string popFront();
    virtual string popRear();
};

#endif // PEEK_DEQUE_H_
