/** File "PeekDequeTemplateAJC.cpp", by AJC.
Adds peek functionality to StringDeque
 */

#include <iostream>
#include <sstream>
#include <string>
#include <vector>

using namespace std;

template <typename T>
class PeekDeque;

template <typename T>
class Deque   //Front of deque is toward 0, but need not be 0.
{
    friend class PeekDeque<T>;
    vector<T>* elements;
    int frontItem;   //CLASS INV: indexes item with least index
    int rearSpace;   //CLASS INV: indexes space after item with greatest index
    int upperBound;  //For array[0..n-1] this is "n" not "n-1".

    //CLASS INV: frontSpace indicates first empty cell for pushFront
    //           rearSpace designates rear item (not space) for popRear---
    //           ---or if there is no such item, rearSpace == frontItem;
public:
    Deque(int guaranteedCapacity):
	elements(new vector<T>(2*guaranteedCapacity)),
	frontItem(guaranteedCapacity),
	rearSpace(guaranteedCapacity),
	upperBound(2*guaranteedCapacity)
    {
    }

    ~Deque() {delete(elements);}

    virtual bool empty() const {
	    return frontItem == rearSpace;
    }

    virtual bool full() const {
	    return rearSpace == upperBound || frontItem == 0;
    }

    virtual int size() const {
	    return rearSpace - frontItem;
    }

    virtual T popRear() {
	    if (empty()) {
	        cerr << "Later we'll define and throw an EmptyQException" << endl;
	        return T();
	    } else {
	        return elements->at(--rearSpace);
	    }
    }

    virtual T popFront() {
	    if (empty()) {
	        cerr << "Later we'll define and throw an EmptyQException" << endl;
	        return T();
	    } else {
	        return elements->at(frontItem++);
	    }
    }

    /** Directions include similarly testing for "full" in the C++ code.
     */
    virtual void pushFront(T newItem)
    {
	    if(full()) {
	        cerr << "Later we'll define and throw an FullQException" << endl;
	    } else {
	        elements->at(--frontItem) = newItem;
	    }
    }
    virtual void pushRear(T newItem)
    {
	    if(full()) {
	        cerr << "Later we'll define and throw a FullQException" << endl;
	    } else {
	        elements->at(rearSpace++) = newItem;
	    }
    }


    virtual string toString() const {
	    ostringstream out;
	    for (int i = frontItem; i < rearSpace; i++) {
	        out << elements->at(i) << " ";
	    }
	    return out.str();
    }
};

template <class T>
class PeekDeque : public Deque<T> {
    int peekIndex;

public:
    PeekDeque<T>(int guaranteedCapacity) : Deque<T>(guaranteedCapacity), peekIndex(this->frontItem) {
    }

    virtual void moveFrontward() {
        if(peekIndex == this->frontItem)
            return;
        peekIndex--;
    }
    
    virtual void moveToFront() {
        peekIndex = this->frontItem;
    }

    virtual void moveRearward() {
        if(peekIndex == this->rearSpace + 1)
            return;
        peekIndex++;
    }

    virtual T peek() {
        if(this->empty()) {
            cerr << "Cannot peek when empty!" << endl;
            return T();
        }
        return (this->elements)->at(peekIndex);
    }

    virtual T popFront() {
        if (this->empty()) {
            cerr << "Attempt to pop from empty PeekDeque" << endl;
            return T();
        } else {
            return (this->elements)->at((this->frontItem)++);
        }
    }

    virtual T popRear() {
        if (this->empty()) {
            cerr << "Attempt to pop from empty PeekDeque" << endl;
            return T();
        } else {
            return (this->elements)->at(--(this->rearSpace));
        }
    }
};
