/**File UserBaseJJZ.h, by Jack Zhan.  Project 2 for CSE250, Spring 2014

 */

#ifndef USERBASEJJZ_H_
#define USERBASEJJZ_H_

#include <iostream>
#include <vector>
#include <fstream>
#include <sstream>
#include <map>
#include "UserJJZ.h"


class UserDatabase
{
public:
   std::vector<User*> Udatabase;
   std::vector<User*>::iterator itr;

public:
   UserDatabase(){}

   /**
   Creates a new User if one does not exisist inUdatabase
   Adds a movie review to that User
   */
   virtual void insert ( int item_id, int movie_id, int rating );

   /**
   Checks to see if the item_id exist in array
    */

   virtual bool checkUser( int item_id );

   /**
    Iterates through User's Reviews grabbing and summing up the value
    Returns the average or sum / count as a float
    */
   virtual float getUserAvgRating ( int item_id );

   /**
    Iterates through User's Reviews grabbing and summing up the rating of a movie id
    Returns the average or sum / count as a float
    */
   virtual float getMovieAvgRating ( int movie_id );

   /**
    Iterates through User's Reviews grabbing and summing all the ratings    Returns the average or sum / count as a float
    */
   virtual float getAllAvgRating ();

   /**
   Iterates through User and get the size of Reviews.
   */
   virtual int getNumRating ( int item_id );

   /**
    Opens a file and adds its content to Udatabase
    */

   virtual void inputData ( string filename );
};

#endif
