/*
"ChainedHashCSP.h"
By Chris Palmer for CSE250 Project 2, Spring 2013
A Hash Table data structure from a Valli.
Provides Rehash Function
*/
//REQ I has hashString() method returns size_t
//OTHER REQ BELOW....


#ifndef ChainedHash_H_
#define ChainedHash_H_

#include "DListCSP.h"
#include <vector>
using std::vector;

template <typename I>
class ChainedHash
{
public:
	class iterator
	{
		typename DList<I>::iterator list_iter;

		iterator(const typename DList<I>::iterator& l_iter)
			:list_iter(l_iter){}

		friend class ChainedHash<I>;

	public:
		iterator(){}

		iterator(const iterator& other)
			:list_iter(other.list_iter){}

		iterator& operator=(const iterator& rhs)
		{
			list_iter = rhs.list_iter;
			return *this;
		}

		I& operator*() const
		{
			return *list_iter;
		}

		iterator& operator++()
		{
			++list_iter;
			return *this;
		}

		iterator operator++(int)
		{
			iterator oldMe = *this;
			list_iter++;
			return oldMe;
		}

        DNode<I>* currNode() const{ //returns the iterator's
        //current node
            return list_iter.currNode();
        }

		bool operator==(const iterator& rhs) const
		{
			return list_iter == rhs.list_iter;
		}

		bool operator!=(const iterator& rhs) const
		{
			return list_iter != rhs.list_iter;
		}
	};

private:
	DList<I> list;
	vector<DNode<I>*> vec;
	size_t n, buckets;
    bool re;
public:
    ChainedHash()
        :list(DList<I>())
		,vec(vector<DNode<I>*>())
		,n(0), buckets(100),re(false){setUp();}

    //default constructor sets up a Hash with 10000 buckets
	explicit ChainedHash(size_t buckets)
		:list(DList<I>())
		,vec(vector<DNode<I>*>())
		,n(0), buckets(buckets),re(false){setUp();}

	~ChainedHash(){}

    void setUp(){
        //This method sets up the Hash. Gives all the Buckets a dummy
        //node of I(). Also adds a Milepost for the endNode
        for (size_t bucket = 0; bucket < buckets; bucket++)
		{
            iterator iter = iterator(list.insert(list.end(), I()));
			vec.push_back(iter.currNode());
		}
		vec.push_back(end().currNode());
    }

	iterator begin() const
	{
		return iterator(list.begin());
	}

	iterator end() const
	{
		return iterator(list.end());
	}

	size_t size() const
	{
		return n;
	}

	bool empty() const
	{
		return size() == 0;
	}

	string str() const
	{
		return list.toString();
	}

    size_t hashValue(I item) const{
        //provides a java Hash value of the given item.
        //returns the hash mod the bucket, so no mod'ing needs
        //to be done after the fact
       string s = item.hashString();
        size_t hash =0;
        for(size_t i = 0; i<s.size();++i){
            hash=hash*31+s[i];
        }
        return hash%buckets;
    }
   
   
	iterator find(const I& item) const
	{
        //returns the iterator of an item in the ChainedHash, or the iterator
        //of end() if not found
        size_t h = hashValue(item);
		for (DNode<I>* curr = vec[h]; curr != vec[h+1]; curr=curr->next)
			if (curr->data == item){
             
				return iterator(list.giveMeIt(curr));
            }
          
		return iterator(list.end());
         
}

	iterator insert(const I& item)
	{
        //inserts the given value into the ChainedHash, does not allow duplicates
        //returns the iterator of it's location
        size_t h = hashValue(item);
        DNode<I>* curr = vec[h];
		for (DNode<I>* curr = vec[h]; curr != vec[h+1]; curr=curr->next){
			if (curr->data == item){
				return iterator(list.giveMeIt(curr));
            }
        }
		++n;
        list.insert(vec[h+1], item);
        //rehashing if load factor>80%
        if(n>4*buckets/5){
            rehash();
        }
		return find(item);

       
	}

   void rehash(){
       //rehashes the data structure by doubling the number of
       //buckets, unsplicing nodes, then resplicing later...

       buckets*=2;
       vector<DNode<I>*> oldStuff;
       iterator itr=begin();
       //splicing out cells with data
       for(size_t i=0;itr!=end();++itr){
           oldStuff.push_back(itr.currNode());
           list.unlink(itr.currNode());
       }
       vec.clear();
       list.clear();
       n=0;
       setUp();
       //resplicing data
       for(size_t i = 0;i<oldStuff.size();i++){
           DNode<I>* eh=oldStuff[i];
           size_t h = hashValue(eh->data);
           DNode<I>* curr = vec[h];
           ++n;
           list.splice(vec[h+1], eh);
       }
   }

    void erase(iterator itr){
        //removes the given iterator's data from the ChainedHash
        //REQ: CANNOT be the end node
        DNode<I>* removed = itr.currNode();
        //checking for removal of the endNode
        if(removed==vec[vec.size()-1]) return;
        for(size_t i = 0; i<vec.size();i++){
            //checking to see if a weighpoint is removed
            if(vec[i]==removed){
                list.remove(removed);
                n--;
                return;
            }
        }
        //otherwise...
        list.remove(removed);
        n--;
    }
};

#endif
