/** File "DListCSP.h", Chris Palmer, Spring 2013 CSE250
Project 2. Adaped from KWR's "DList.h". Added functionality
for compatibility with ChainedHash.
REQs for I below, note at bottom needs str method...
 */
#ifndef DLIST_H_
#define DLIST_H_

#include <iostream>
#include <sstream>
#include <string>

using std::string;     
using std::iostream;   
using std::ostringstream;
using std::cout;
using std::cerr;
using std::endl;


template <typename I>  //REQ: I has I(), operator<<(iostream&, const I&)
class DList;


/** A DNode is the building block for a double-linked list.  Text uses struct
    to make data fields public---later (of course!) we will encapsulate it.
 */
template <typename I>
struct DNode {
  /** A pointer to the list I belong to---added by KWR.
   */
  DList<I>* myList;

  /** A copy of the data   (KWR: we might use pointers to avoid copying)
   */
  I data;

  /** Pointers to previous and next DNode (KWR: note different order from text)
   */
  DNode<I>* prev;
  DNode<I>* next;

  DNode(DList<I>* myList, const I& item, DNode<I>* prev = NULL,
                                         DNode<I>* next = NULL)
   : myList(myList), data(item), next(next), prev(prev) 
  { }
};


template <typename I>    //Written by KWR. 
class DList {
   DNode<I>* firstNode;  //by convention, a "real" node

   //CLASS INV: firstNode always points to first node, endNode to dummy node
   //CLASS INV: Empty list exactly when firstNode == endNode == the dummy node
   //CLASS INV: endNode never changes; we only insert before it.
 public:
      DNode<I>* endNode;  //by convention, a dummy node. Use to end while loops.
   DList<I>() 
    : firstNode(new DNode<I>(NULL, I(), NULL, NULL))
    , endNode(firstNode)
   { firstNode->myList = endNode->myList = this;}

   /** Example of destructor added by KWR.  Using "cerr" guarantees 
       immediate screen output.
    */
   virtual ~DList<I>() {
      DNode<I>* current = endNode;
      while (current != firstNode) {
         
         current = current->prev;
         delete(current->next);
      }
      delete(current);  
   }

   void clear()
   {
	  
      DNode<I>* current = endNode;
      while (current != firstNode) {
        
         current = current->prev;
         delete(current->next);
      }
      delete(current);  
	  endNode = firstNode = new DNode<I>(this, I(), NULL, NULL);
   }

   class iterator {
      friend class DList<I>;
      friend struct DNode<I>;  

      DNode<I>* curr;

      explicit iterator(DNode<I>* given) : curr(given) { }

     public:
	  iterator():curr(NULL){}

      I& operator*() const { return curr->data; }  //allows assignment
      //WARNING, by allowing assgt this allows breaking Valli's sortedness INV

      //REQ: curr != endNode, else may bomb
      //Alternative conventions are endNode->next == endNode, or == firstNode!
      iterator& operator++() { 
         curr = curr->next;
         while(curr->data==I()&&curr!=curr->myList->endNode){
    
            curr = curr->next;
         }
         return *this;   //reference to self is returned
      }
   
      DNode<I>* currNode() const{//Returns the current node of the iterator
            return curr;
           }

      //REQ: curr != endNode, else may bomb
      iterator operator++(int x) {
         iterator oldMe = *this;  //uses copy ctor
         curr = curr->next;
         while(curr->data==I()&&curr!=curr->myList->endNode){
         
            curr = curr->next;
         }
         return oldMe;   //COPY of old self is returned
      }

      bool operator==(const iterator& other) const {
         return curr == other.curr;
      }
      bool operator!=(const iterator& other) const {
         return curr != other.curr;
      }
   };

   DNode<I>* pbegin() const { return firstNode; }  
   DNode<I>* pend() const { return endNode; }


   iterator begin() const { return iterator(firstNode); }
   iterator end() const { return iterator(endNode); }

   void insert(DNode<I>* beforeMe, I newItem) {  
      
      DNode<I>* newNode = new DNode<I>(this,newItem,beforeMe->prev,beforeMe);

      if (beforeMe->prev != NULL) {   //i.e. if we're not inserting a new first
        
 
          beforeMe->prev->next = newNode;
           
         beforeMe->prev = newNode;  //don't forget!
      } else {
           
         beforeMe->prev = newNode;
         firstNode = newNode;
      }
     
   }

   iterator giveMeIt(DNode<I>* node) const{
       //returns an iterator for a given node
       return iterator(node);
   }
   void unlink(DNode<I>* currNode){
       //Unlinks the given node from the list
       //REQ: node must be in the list
       //REQ: cannot be the endNode
       if(currNode==firstNode){//the case where we remove first node
           currNode->next->prev=NULL;
           firstNode=currNode->next;
          
       }

       else if(currNode==endNode){//trying to remove last node
           return;
       }
       else{//removing any other node
           currNode->prev->next=currNode->next;
           currNode->next->prev=currNode->prev;
           
       }

   }
   void splice(DNode<I>* beforeMe, DNode<I>* newNode) { 
        //Splices in the given node
      newNode->prev=beforeMe->prev;
      newNode->next=beforeMe;
      

      if (beforeMe->prev != NULL) {   //i.e. if we're not inserting a new first
        
 
          beforeMe->prev->next = newNode;
           
         beforeMe->prev = newNode;  //don't forget!
      } else {
           
         beforeMe->prev = newNode;
         firstNode = newNode;
      }
     
   }

   void remove(DNode<I>* currNode){
       //removes a given node from the list
       //REQ: node must be in the list
       //REQ: cannot be the endNode
       if(currNode==firstNode){//the case where we remove first node
           currNode->next->prev=NULL;
           firstNode=currNode->next;
           delete currNode;
       }

       else if(currNode==endNode){//trying to remove last node
           return;
       }
       else{//removing any other node
           currNode->prev->next=currNode->next;
           currNode->next->prev=currNode->prev;
           delete currNode;
       }

   }

   iterator insert(iterator it_beforeMe, I newItem) {
       //inserting newItem after the first data in the
       //it_beforeMe iterator
	  DNode<I>* beforeMe = it_beforeMe.curr;
	  insert(beforeMe, newItem);
	  return iterator(beforeMe->prev);
   }

   size_t size() const {            
       //Returns size of the list
      size_t count = 0;
      DNode<I>* current = firstNode;
      while (current != endNode) {
         count++;
         current = current->next;
      }
      return count;
   }

   //change to use the iterator internally
   string toString() const {       //Node resemblance to code in Deque<I> class
      ostringstream OUT;
      //DNode<I>* current = firstNode;
      iterator itr = begin();
      //while (current != endNode) {
      while (itr != end()) {
         //OUT << current->data << " ";  //REQ of T having operator<< used here.
         //current = current->next;

          //changed mind, now T needs str() method
         OUT << (*itr).str() << " ";
         ++itr;
      }
      return OUT.str();
   }

   string str() const {
      return toString();
   }

};
#endif
