/*
"HalliCSP.h"
By Chris Palmer for CSE250 Project 2, Spring 2013
A Hash Table data structure from a Valli.
First Draft.
*/
//REQ I has hashString() method returns size_t


#ifndef Halli_H_
#define Halli_H_

#include "DListCSP.h"
#include <vector>
using std::vector;

template <typename I>
class Halli
{
public:
	class iterator
	{
		typename DList<I>::iterator list_iter;

		iterator(const typename DList<I>::iterator& l_iter)
			:list_iter(l_iter){}

		friend class Halli<I>;

	public:
		iterator(){}

		iterator(const iterator& other)
			:list_iter(other.list_iter){}

		iterator& operator=(const iterator& rhs)
		{
			list_iter = rhs.list_iter;
			return *this;
		}

		I& operator*() const
		{
			return *list_iter;
		}

		iterator& operator++()
		{
			++list_iter;
			return *this;
		}

		iterator operator++(int)
		{
			iterator oldMe = *this;
			list_iter++;
			return oldMe;
		}

        DNode<I>* currNode() const{ //returns the iterator's
        //current node
            return list_iter.currNode();
        }

		bool operator==(const iterator& rhs) const
		{
			return list_iter == rhs.list_iter;
		}

		bool operator!=(const iterator& rhs) const
		{
			return list_iter != rhs.list_iter;
		}
	};

private:
	DList<I> list;
	vector<DNode<I>*> vec;
	size_t n, buckets;

public:
    Halli()
        :list(DList<I>())
		,vec(vector<DNode<I>*>())
		,n(0), buckets(10000){setUp();}
	explicit Halli(size_t buckets)
		:list(DList<I>())
		,vec(vector<DNode<I>*>())
		,n(0), buckets(buckets){setUp();}

	~Halli(){}

    void setUp(){
        for (size_t bucket = 0; bucket < buckets; bucket++)
		{
            iterator iter = iterator(list.insert(list.end(), I()));
			vec.push_back(iter.currNode());
		}
		vec.push_back(end().currNode());
    }

	iterator begin() const
	{
		return iterator(list.begin());
	}

	iterator end() const
	{
		return iterator(list.end());
	}

	size_t size() const
	{
		return n;
	}

	bool empty() const
	{
		return size() == 0;
	}

	string str() const
	{
		return list.toString();
	}
    size_t hashValue(I item) const{
        //provides a java Hash value of the given item.
       string s = item.hashString();
      size_t hash =0;
        for(size_t i = 0; i<s.size();++i){
            hash=hash*31+s[i];
        }
        return hash%buckets;
    }
   
   
	iterator find(const I& item) const
	{
        //returns the iterator of an item in the Halli, or the iterator
        //of end() if not found
        size_t h = hashValue(item);
		for (DNode<I>* curr = vec[h]; curr != vec[h+1]; curr=curr->next)
			if (curr->data == item)
				return iterator(list.giveMeIt(curr));
		return iterator(list.end());
}

	iterator insert(const I& item)
	{
        //inserts the given value into the Halli, does not allow duplicates
        size_t h = hashValue(item);
		for (DNode<I>* curr = vec[h]; curr != vec[h+1]; curr=curr->next)
			if (curr->data == item)
				return iterator(list.giveMeIt(curr));
		++n;
        list.insert(vec[h+1], item);
		return iterator(list.giveMeIt(vec[h+1]));

       
	}
   

    void erase(iterator itr){
        //removes the given iterator's data from the Halli
        //REQ: CANNOT be the end node
        DNode<I>* removed = itr.currNode();
        //checking for removal of the endNode
        if(removed==vec[vec.size()-1]) return;
        for(size_t i = 0; i<vec.size();i++){
            //checking to see if a weighpoint is removed
            if(vec[i]==removed){
                list.remove(removed);
                n--;
                return;
            }
        }
        //otherwise...
        list.remove(removed);
        n--;
    }
};

#endif
