/*
* HeapSPK.h by Sean Kafer 37654863
* Adapted from Mahmoud's version shown in Recitation.
*/

#ifndef HEAP_H_
#define HEAP_H_
#include <vector>
using std::vector;

template <typename T>
class Heap
{
public:
    vector<T> item;

    Heap(): item(vector<T>(1)){}

    int size() const
    {
        //returns size of the heap
        return item.size()-1;
    }

    void fix_down(int index)
    {
        //filters down the given index to it's rightful home
        T temp = item[index];
        while(2*index<=size())
        {
            int child = 2*index;
            if(child<size()&&item[child+1]>item[child])
                child++;
            if (temp>=item[child])
                break;
            item[index]=item[child];
            index=child;
        }
        item[index]=temp;
    }

    void make_heap()
    {
        //ensures that the vector item is a valid heap
        for(int index=size()/2; index>=1; index--)
            fix_down(index);
    }

    T pop()
    {
        //returns the top element of the vector, 
        //repositions the element that takes its place
        T temp = item[1];
        item[1]=item[size()];
        item.pop_back();
        if (size()>0)
            fix_down(1);
        return temp;
    }

    void push(T new_item)
    {
        //pushes the new item into the vector
        item.push_back(new_item);
        //fix_up
    }


};




#endif
