/*
"StockClientCSPSPK"
By Chris Palmer and Sean Kafer for CSE250 Project 2, Spring 2013
Client file. REQ commands only of the following form:

add? STOCKTICKER SIZE_TsDOUBLE
STOCKTICKER SIZE_TsDOUBLE
printTopByVolume? K
printTopByPercentUp? K
printTopByPercentDown? K
printTopByPercentChange? K
printTopByMomentum? K
printTopByTrendTrades? K
printTopByTrendShares? K

other performance not Guaranteed. K is the number you
would like printed, STOCKTICKER just represents a string

Example:
add? AAPL 100s10.0
printTopByVolume? 10

Uses Heaps and HashTable to get the job done. 

*/

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <vector>
#include <sstream>
#include "ChainedHashCSP.h"
#include "StockSPK.h"
#include "HeapSPK.h"
using namespace std;

size_t stringChecker(string s){
    //this method parses a given string and returns
    //which of the following commands it is as a size_t
    if(s=="add?")
        return 1;
    if(s=="printTopByVolume?")
        return 2;
    if(s=="printTopByPercentUp?")
        return 3;
    if(s=="printTopByPercentDown?")
        return 4;
    if(s=="printTopByPercentChange?")
        return 5;
    if(s=="printTopByMomentum?")
        return 6;
    if(s=="printTopByTrendTrades?")
        return 7;
    if(s=="pause?")
        return 8;
    if(s=="printTopByTrendShares?")
        return 9;
    return 0;
}

size_t getShares(string& s){
    //returns the number of shares as a size_t 
    //from a given string in the format listed above
    string shares;
    for(size_t i = 0; i<s.size();i++){
        if(s[i]=='s')
            break;
        shares+=s[i];
    }
    int i =atoi(shares.c_str());
    return i;
}

double getPrice(string& s){
    //returns the price as a double from a given
    //string in the format listed above
    string price;

    size_t i;
    for(i = 0; i<s.size();i++){
        if(s[i]=='s')
            if(++i<s.size())
                break;
    }
    while(i<s.size()){
        price+=s[i];
        i++;
    }
    double d =atof(price.c_str());
    return d;
}

template<class I>
void topShenanigans(Heap<I>& heap, size_t& num,size_t& state){
    //This method takes a given heap, num = Top K, and state(given item
    //to search for. Prints out the necessary information based on said 
    //criteria, then fixes the heap it destroyed.
    vector<I> top;
    int i =0;
    for(size_t i = 0; i<num&&heap.size()>0;i++){
        top.push_back(heap.pop());
        const Stock& stock =*top[top.size()-1];
        cout<<"Number "<<i+1<<" is: "<<stock.str()<<" : ";
        switch(state){
        case 2:
            cout<<stock.Volume()<<endl;
            break;
        case 3:
            cout<<stock.PercentUp()<<endl;
            break;
        case 4:
            cout<<stock.PercentDown()<<endl;
            break;
        case 5:
            cout<<stock.PercentChange()<<endl;
            break;
        case 6:
            cout<<stock.Momentum()<<endl;
            break;
        case 7:
            cout<<stock.Trend()<<endl;
            break;
        case 9:
            cout<<stock.TrendShares()<<endl;
        }
    }
    for(size_t i =0;i<top.size();i++){
        heap.push(top[i]);
        //fixing the poor heap....
    }

}

bool scanFormat(string s){
    //checks to see if the given line is correct syntax
    //for processing a trade
    if(s.length()<1)
        return false;
    size_t i =0;
    while(i<s.length()){
        //This loop looks for the first half...
        if (s[i]=='s'){
            i++;
            break;
        }
        char c= s[i];
        if(c!='0'&&c!='1'&&c!='2'&&c!='3'&&c!='4'&&c!='5'&&
            c!='6'&&c!='7'&&c!='8'&&c!='9'){
                return false;
        }
        i++;
    }
    while(i<s.length()){
        //this loop seaches through the second half..
        char c= s[i];
        if(s[i]=='.'){
            i++;
            break;
        }
        if(c!='0'&&c!='1'&&c!='2'&&c!='3'&&c!='4'&&c!='5'&&
            c!='6'&&c!='7'&&c!='8'&&c!='9'){
                return false;
        }
        i++;
    }
    while(i<s.length()){
        //this checks second half after the decimal
        char c= s[i];
        if(c!='0'&&c!='1'&&c!='2'&&c!='3'&&c!='4'&&c!='5'&&
            c!='6'&&c!='7'&&c!='8'&&c!='9'){
                return false;
        }
        i++;
    }
    return true;
    //we made it! return true
}

int main(int argC, char* argV[]){
    if (argC > 1)
    {
        ifstream fin(argV[1]);
        if (fin.is_open()){
           
            //setting up...
            ChainedHash<Stock> hal;
            Heap<ProxyVolume> hVolume;
            Heap<ProxyPercentUp> hPercentUp;
            Heap<ProxyPercentDown> hPercentDown;
            Heap<ProxyPercentChange> hPercentChange;
            Heap<ProxyMomentum> hMomentum;
            Heap<ProxyTrend> hTrend;
            Heap<ProxyTrendShares> hTrendShares;
            string command;
            string word;
            string name;
            size_t shares;
            double cost;
            size_t state =0;
            while (getline(fin,word)){
                //get the next line of code...
                stringstream ss(word);
                if(ss>>command)
                    //gets which command is at the front of the line
                    state=stringChecker(command);
                switch(state){
                    //switch statement for all our given commands
                case 0:
                    //This case is no command entered, therefore the name of
                    //our stock is command
                    name=command;
                    if(ss>>command){
                        //checking to see if this is a valid line...
                        if(!scanFormat(command)){
                            cout<<"Bad format on this line: "<<endl<<word<<endl;
                            break;
                        }
                        //getting the info
                        shares=getShares(command);
                        cost=getPrice(command);
                        Stock* fStockPtr =&*hal.find(name);
                        if(fStockPtr==&*hal.end())
                            break;
                        //processing the trade if the given stock was found
                        fStockPtr->process_trade(shares,cost);
                    }
                    break;
                case 1:
                    //The case where we are adding a stock...
                    if(ss>>name){
                        if(ss>>command){
                            //getting info/creating Stock
                            shares=getShares(command);
                            cost=getPrice(command);
                            Stock stock(name,shares,cost);
                            if(hal.find(stock)==hal.end()){
                                //Inserting the Stock ONLY IF it isn't present
                                //Can only insert one stock, any other insertions
                                //not allowed
                                Stock* stockPtr=&*hal.insert(stock);
                                hVolume.push(stockPtr);
                                hPercentUp.push(stockPtr);
                                hPercentDown.push(stockPtr);
                                hPercentChange.push(stockPtr);
                                hMomentum.push(stockPtr);
                                hTrend.push(stockPtr);
                                hTrendShares.push(stockPtr);
                            }
                        }
                    }
                    break;
                case 2:
                    //This case processess Volume
                    if(ss>>name){
                        //getting howw many to search for, here shares
                        //represents top K
                        shares=(atoi(name.c_str()));
                        //Getting the heap in order
                        hVolume.make_heap();
                        cout<<"Top by Volume is: "<<endl;
                        //Printing out necessary information
                        topShenanigans(hVolume,shares,state);
                    }
                    break;
                case 3:
                    //The case for PercentUp, see Case 2 for more info
                    if(ss>>name){
                        shares=(atoi(name.c_str()));
                        hPercentUp.make_heap();
                        cout<<"Top by Percent Up is: "<<endl;
                        topShenanigans(hPercentUp,shares,state);
                    }
                    break;
                case 4:
                    //The case for PercentDown, see Case 2 for more info
                    if(ss>>name){
                        shares=(atoi(name.c_str()));
                        hPercentDown.make_heap();
                        cout<<"Top by Percent Down is: "<<endl;
                        topShenanigans(hPercentDown,shares,state);
                    }
                    break;
                case 5:
                    //The case for PercentChange, see Case 2 for more info
                    if(ss>>name){
                        shares=(atoi(name.c_str()));
                        hPercentChange.make_heap();
                        cout<<"Top by Percent Change is: "<<endl;
                        topShenanigans(hPercentChange,shares,state);
                    }
                    break;
                case 6:
                    //The case for Momentum, see Case 2 for more info
                    if(ss>>name){
                        shares=(atoi(name.c_str()));
                        hMomentum.make_heap();
                        cout<<"Top by Momentum is: "<<endl;
                        topShenanigans(hMomentum,shares,state);
                    }
                    break;
                case 7:
                    //The case for Trend Trades, see Case 2 for more info
                    if(ss>>name){
                        shares=(atoi(name.c_str()));
                        hTrend.make_heap();
                        cout<<"Top by Trend Trades is: "<<endl;
                        topShenanigans(hTrend,shares,state);
                    }
                    break;
                case 8:
                    //The case for pause
                    cout<<"Pause initiated. Please type something and then press enter..."<<endl;
                    cin>>name;
                    break;
                case 9:
                    //The case for Trend Shares, see Case 2 for more info
                    if(ss>>name){
                        shares=(atoi(name.c_str()));
                        hTrendShares.make_heap();
                        cout<<"Top by Trend Shares is: "<<endl;
                        topShenanigans(hTrendShares,shares,state);
                    }
                    break;
                }
            }
        }
    }
    return 0;
}


/*
Report Questions:

1A:

(a) My Hash stores DNode<I>*. In DNode though, the data is
stored as a value(technically as a const I&).

(b) Yes, I allocated "Dummy" nodes for each of the buckets up 
front.

(c) I realied on identifying the dummies by the default constructor
of I() and I's operator==

(d) I did not recycle dummies, Dummies stayed dummies.

(e) My iterator was not allowed to stop at a Dummy node, if 
it was a dummy it passed over it. end() was handled the same as in
previous project, it still had its own reference.

(f) I relied on the operator== for the Stock class(which checked the 
Tickers.

(g) This iterator skips over the "Dummy" node. That's the only 
added functionality.

(h) The more Class INV the better! I added things like requires str(),
hashString(), <. == The more you could specifiy your data the better!




1B:


a) Proxy objects

b) It gets information directly via the proxy object.

c) No, it is only properly made properly a heap when before it needs to be.  The Heap
   invariants are not maintained when top lists are not being requested.

d) We did not use function objects but instead defined < operators for proxy objects.
   These operators take arguments of type const (similar proxy object)&, i.e:
   ProxyVolume's < operator takes arguments of type const ProxyVolume&.

e) Again, we did not use function objects, so friending wasn't necessary. We simply had
   pointers to the Stock objects, and these pointers were used to get information about
   the stocks so we could call the < operators.

f) It assumes the client will do it, providing the Stock class the information about how
   many shares to trade.

g) It maintains fields which it updates when trades happen.

h) We had not considered it.  It does seem to violate ideas of making our programming
   generic, as this would mean that the HashTable class wouldn't actually have any call
   int it's programming to generate a hash value for it's inputs, which for other kinds
   of data would be a problem.







2:

(a) Average for Chained Hash w/ Heap:
.2865135 seconds
(timing was done w/o rehash)

(b) Average for Valli w/ Heap
.517894 seconds

This is definetely slower than a

You can certaintly see Valli was slower than the heap. There
was not that much flux throughout the trials. The conclusion is that
Chained Hash is indeed a faster data structure in this case than the
Valli. We could tell that Hashing is more efficent than using a sorted
data structure.



3

Was implemented in our code. Momentum Extremely varries from Percent
Change


4

Was implemented in our code
it runs in O(1) time by maintaining a trendShares field that updates as trades happen,
much the same way that the regular trend fiend updates every time trades happen.

5

Was NOT done


*6*
Rehash was implemented by our code

*/
