/** File "TwoStacksCSP.cpp" by Chris Palmer for CSE 250, Spring 2013. Provides 
    an implementation to the header file "TwoStacksCSP.cpp". This is a two 
    stack data structure, with both stacks growing from the end.
*/

#include "TwoStacksCSP.h"
TwoStacks::TwoStacks(int gcap){
   elements= vector<char>(gcap);
   frontItem= -1; //INV frontItem==-1 designates the empty position of Stack A
   rearItem=gcap; //INV rearItem==gcap designates the empty position of Stack B
   cap=gcap;
}
bool TwoStacks::isEmptyA(){ return frontItem==-1;}
bool TwoStacks::isEmptyB(){ return rearItem==cap;}
char TwoStacks::popA(){return elements[frontItem--];}
char TwoStacks::popB(){return elements[rearItem++];}
void TwoStacks::pushA(char newItem){elements[++frontItem]=newItem;}
void TwoStacks::pushB(char newItem){elements[--rearItem]=newItem;}
int TwoStacks::size(){return(frontItem+1+cap-rearItem);}
   
