/*
"ValliCSP.h"
By Chris Palmer for CSE250 Assingment 8 Spring 2013
Adapted from "llalli.h" by Mahmoud Abo Khamis
Implementation of Valli data structure, combining the
features of vector and linked list with iterator.
edited 4/2 to adress an issue with inserting before the
first node...
*/

#ifndef VALLI_H_
#define VALLI_H_

#include "DListCSP.h"
#include <vector>
using std::vector;

template <typename I>
class Valli
{
public:
	class iterator
	{
		typename DList<I>::iterator list_iter;

		iterator(const typename DList<I>::iterator& l_iter)
			:list_iter(l_iter){}

		friend class Valli<I>;

	public:
		iterator(){}

		iterator(const iterator& other)
			:list_iter(other.list_iter){}

		iterator& operator=(const iterator& rhs)
		{
			list_iter = rhs.list_iter;
			return *this;
		}

		I& operator*() const
		{
			return *list_iter;
		}

		iterator& operator++()
		{
			++list_iter;
			return *this;
		}

		iterator operator++(int)
		{
			iterator oldMe = *this;
			list_iter++;
			return oldMe;
		}

        DNode<I>* currNode() const{ //returns the iterator's
        //current node
            return list_iter.currNode();
        }

		bool operator==(const iterator& rhs) const
		{
			return list_iter == rhs.list_iter;
		}

		bool operator!=(const iterator& rhs) const
		{
			return list_iter != rhs.list_iter;
		}
	};

private:
	DList<I> list;
	vector<DNode<I>*> vec;
	size_t n, r;

public:
    Valli()
        :list(DList<I>())
		,vec(vector<DNode<I>*>())
		,n(0), r(20){refresh();}
	explicit Valli(size_t ratio)
		:list(DList<I>())
		,vec(vector<DNode<I>*>())
		,n(0), r(ratio){refresh();}

	~Valli(){}

	iterator begin() const
	{
		return iterator(list.begin());
	}

	iterator end() const
	{
		return iterator(list.end());
	}

	size_t size() const
	{
		return n;
	}

	bool empty() const
	{
		return size() == 0;
	}

	string str() const
	{
		return list.toString();
	}

	void refresh(size_t newRatio)
	{//refreshes the Valli to restore balance
		r = newRatio;
		size_t count = r;
        size_t added =0;
        vec.clear();
		for (iterator iter = begin(); iter != end(); iter++, count++){
        	//reassigning weighpoints.
            //LOOP INV: iter does not get the endpoint
            if (count == r)
			{
              
				count = 0;
                vec.push_back(iter.currNode());
               
            }
        }
        if(begin()==end()) vec.push_back(begin().currNode());
       //guaranteeing 2 weighpoints for an empty Valli
        vec.push_back(end().currNode());//giving the endpoint a weighpoint
	}
    
	void refresh()
	{
		refresh(r);
	}
    
    DNode<I>* findHelper(const I& item) const{
        //Helper method to locate a particular element, or where the
        //element should be inserted
        size_t left = 0;
        size_t right = vec.size()-1;
        while(right>left+1){
            //Binary search of the weighpoints
            size_t mid = (right + left)/2;
            if (item < vec[mid]->data) {
                right = mid;
            }   
            else {
                left = mid;
            }
        }
               //Loop INV right=left+1;
 
        for(DNode<I>* node=vec[left]; node!=vec[right];node=node->next){
      //    Linear search of the selcted weighpoints
      //    Loop INV: node will not be the node of the 2nd weighpoint
            if(node->data>=item){
                return node; 
            }
        }
        return vec[right];//if item is not found between weighpoints,
            //return the right weighpoint
    }

   

	iterator find(const I& item) const
	{
        //returns the iterator of an item in the Valli, or the iterator
        //of end() if not found
    DNode<I>* yay =findHelper(item);
     if(yay->data==item){  
        return iterator(list.giveMeIt(yay));
          }
     else{return end();}	
}

	iterator insert(const I& item)
	{
        //inserts the given item into the Valli, returns an iterator
        // of the inserteds' location  
        DNode<I>* yay =findHelper(item);
       
        list.insert(yay,item);
       
        if(item==list.pbegin()->data) refresh();
        if(n==0){refresh();}//refresh the list after 1st insertion
       if (++n > 2 * r * vec.size()){
            //refresh the list if the above condition is met
			refresh();
       }
        return iterator(list.giveMeIt(yay));
		
	}
   

    void erase(iterator itr){
        //removes the given iterator's data from the Valli
        //REQ: CANNOT be the end node
        DNode<I>* removed = itr.currNode();
        //checking for removal of the endNode
        if(removed==vec[vec.size()-1]) return;
        for(size_t i = 0; i<vec.size();i++){
            //checking to see if a weighpoint is removed
            if(vec[i]==removed){
                list.remove(removed);
                refresh();
                n--;
                return;
            }
        }
        //otherwise...
        list.remove(removed);
        n--;
    }
};

#endif
