/** File "dictlookupCSP.cpp" by Chris Palmer for CSE250, spring
    2013. The main function of this class takes an input file
    path, which is assumed to be alphabatized, all lower case,
    one word per line, and no extra whitespace characters. 
    Takes each of these lines and puts it in a vector<string>.
    Then, it goes through the lines again, this time flipping first
    and second half of words (the middle letter in an odd numbered
    word is assumed of the latter half). Ex. "12345"->"21543"
    Then it goes through a binary search of the new word against the
    vector to see if it was in the original file. Finally, outputs
    These pairs to "pairs.txt" in this order:
    original word:flipped word
    and on the last line, displays the number of found pairs.
    Duplicates included. Words of length less than 4 excluded.
*/


#include "StackPairCSP.h"
#include <string>
#include <fstream>


string wordTurn(const string& word){
    //Takes @param const string& word. Uses StackPair<T> to flip
    //the first and second half of a given word. The middle letter of
    //an odd numbered word is considered part of the latter half.
    //Ex. "abcde"->"baedc", returns string, the flipped word
    string newWord("");
    int p =0;
    int l =word.length();
    StackPair<char> stack(l);
    for(int i=0; i<(l/2);i++){ //Loop INV pushes only the first half of the
       stack.pushA(word[i]);  //word into stack A
    }
    for(int i=(l/2);i<l;i++){ //Loop INV puses only the rear half of the
       stack.pushB(word[i]); //word into stack B
    }
    while(!stack.isEmptyA()){ //Loop INV pops the elements of Stack A in
       newWord+=stack.popA();    //reverse order while A still has elements
    }
    while(!stack.isEmptyB()){ //Loop INV pops the elements of Stack B in
      newWord+=stack.popB();//reverse oreder while B still has elements
    }
    return newWord;
}

string binsearch(const vector<string>& words, const string& word){
    /*  Takes @param const vector<string>& words, a vector to be
        checked for @param const string& word, the word looked for.
        Provides a binary search for the word, going char by char
        through both word and an element from words. Returns the string of
        the found word, or the empty string "", otherwise
    */

    int end = words.size()-1;
    int begin = 0;
    string trial;
    int length= word.length();   
    while(begin<=end){ //LOOP INV the begin index must not be greater than
        int mid = (end+begin)/2; //the end index
        trial = words[mid];
        bool flag = true;
        for(int i =0; i<length; i++){ //LOOP INV i is in bounds of word
            if(flag){ //ENS Indexes not alterted more than 1 per look up                
                if(i<(trial.length())){//ENS i in bounds of trial
                 if(word[i]==trial[i]);
                   else if(word[i]>trial[i]){
                       flag = false;
                       begin = mid+1;
                    }
                    else{
                        flag = false;
                       end = mid-1;
                   }
              }
                    else{
                       flag = false;
                       begin = mid+1;
                   }
             }
        }
        if(flag){
            if(trial.length()>word.length()){//ENS the found match is indeed
                flag=false;                  //    a match
                end=mid-1;
            }
            else return trial;
        }
    }       
    return "";
}

int main(int argc, char* argv[]){
    /*  Takes the first argument, and provides functionality as described 
        in the definition above
    */
    //REQ given file is sorted alphabetically, one word per line, no extra
    //    whitespaces
    string input("");
    if(argc>1){
        input = argv[1];
      }
    else{
        cout<<"You need a command line argument"<<endl;
        return 0;
    }
    ifstream fin(input.c_str());
    string name; 
    int i=0;
    if(fin.is_open()){ //First loop to find number of lines in file
        while(!fin.eof()){//LOOP INV End of File not reached
            i++;
            getline(fin, name);
        }
        fin.close();
    }
    else{
        cout<<"File not read"<<endl;
        return 0;
    }
    ifstream fin1(input.c_str());
    vector<string> v(i); 
    if(fin1.is_open()){ //Second Loop to convert file into a vector
        i=0;
        while(!fin1.eof()){//LOOP INV End of File not reached
            getline(fin1, name);
            v[i++]=name;
        }
        fin1.close();
    }
    else{
        cout<<"File not read"<<endl;
        return 0;
    }
    i=0;
    int pairs =0;
    ofstream fout("pairs.txt");
    while(i<v.size()){ //LOOP INV i stays in bounds of v
        name = v[i++];
        if(name.length()>3){
            string trial = binsearch(v, wordTurn(name));
            if (trial!=""){
                pairs++;
                fout<<name<<":"<<trial<<endl;
            }
        }
    }
    fout<<"Number of Pairs is: "<<pairs<<endl;
    fout.close();
    return 0;
}
/*  Report Questions:
    
    option 1 is O(nlogn) because binary search is O(logn), the number of 
    elements searched is n, so you do binary search n times, n*logn-> O(nlogn)

    option 2 is O(nlogn) because a set needs O(logn) per item added and O(logn)
    per lookup. So you have n items added and n look ups, nlogn + nlogn =2nlogn
    =O(nlogn)

    option 3 is O(nlogn) because the sort uses a O(nlogn) function. So you would
    have nlogn for the function + n for the lookup, nlogn+n = O(nlogn)

    (a) This would be preferable to binsearch. Because our setting up of the
    vector would be n*1, our search would be n*1, so our total time would be
    n+n = 2n = O(n)

    (b)This too is preferable to binsearch. In essense, it is option 3, just 
    providing an n function instead of an nlogn. You will take n additions 
    to a first vector, n for this function, then n lookups. n+n+n=O(n)

*/





