/* File 'vallidriverCSP.cpp' written by Chris Palmer for
CSE250 Spring 2013 Assignment 8. Takes files with lines of the 
form:

insert ...
find ...
erase ... 
print

... must be 1 word, performance is not guaranteed otherwise

insert will insert ... into a Valli

find will print out "Found: ..." if ... is in the Valli
"Not Found: ..." otherwise

erase will remove ... from the Valli if present
will say "Could not erase: ..." otherwise

print will print out the Valli
*/


#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <vector>
#include "ValliCSP.h"
using namespace std;





bool insert(Valli<string>* val, string word){
    val->insert(word);
    return true;
}
bool erase(Valli<string>* val, string word){
    Valli<string>::iterator it = val->find(word);
    if(it==val->end()){
        return false;
    }
    else{
        val->erase(it);
        return true;
    }
}

int main(int argC, char* argV[]){
    
    if (argC > 1)
	{
		ifstream fin(argV[1]);
		if (fin.is_open()){
			Valli<string> val;
           
			while (!fin.eof()){
                string word;
                
				fin >> word;
             
                if(word=="insert"){
                    if(!fin.eof()){
                        fin>>word;
                        insert(&val,word);
                    }
                }
                else if(word=="find"){
                    if(!fin.eof()){
                        fin>>word;
                        Valli<string>::iterator it= val.find(word);
                        DNode<string>* d = it.currNode();
                        if(d->data==word){
                            cout<<"Found: "<<word<<endl;
                        }
                        else cout<<"Not Found: "<<word<<endl;
                    }
                }
                else if(word=="erase"){
                    if(!fin.eof()){
                        fin>>word;
                        if(erase(&val,word)){
                           // cout<<"Erased: "<<word<<endl;
                        }
                        else cout<<"Could not erase: "<<word<<endl;;
                    }
                }
                else if(word =="print"){
                    cout<<val.str()<<endl;
                }


			}
            
            
		}
       
    }

    
    return 0;
}



