/** File "wordturn2CSP.cpp" by Chris Palmer for CSE 250, Spring 2013. Provides a
    main method for the template class defined in "StackPairCSP.h". Reverses the
    first half and rear half of a word. If a word has an odd number of
    char, the middle char is designated to the rear half. Example:
    input(123454321)->output(432112345)
*/
#include "StackPairCSP.h"

int main(int argc, char* argv[]){
   if (argc>1){
      string input(argv[1]);
      int l = input.length();
      StackPair<char> stack(l);
      for(int i=0; i<(l/2);i++){ //Loop INV pushes only the first half of the
         stack.pushA(input[i]);  //word into stack A
      }
      for(int i=(l/2);i<l;i++){ //Loop INV puses only the rear half of the
         stack.pushB(input[i]); //word into stack B
      }
      while(!stack.isEmptyA()){ //Loop INV pops the elements of Stack A in 
         cout<<stack.popA();    //reverse order while A still has elements
      }
      while(!stack.isEmptyB()){ //Loop INV pops the elements of Stack B in 
         cout<<stack.popB();    //reverse oreder while B still has elements
      }
      cout<<endl;
   }
   return 0;
}



