/* c++ conversion of DequeTest.java.
* Project 2 for CSE 250
* Gagandip Singh
*/

#include <iostream>
#include <vector>

using namespace std;


class StringDeque 
{
	vector<string>* elements;
   int frontItem;
   int rearSpace;
   int upperBound; 

 public:
   /** Create empty stack
    */
  StringDeque(int guaranteedCapacity):
              elements(new vector<string>(2 * guaranteedCapacity)),
              frontItem(guaranteedCapacity),
              rearSpace(guaranteedCapacity),
              upperBound(2 * guaranteedCapacity)
  {
    
  }

   virtual ~StringDeque() { }   //AOK to omit this line, despite warning
   virtual bool empty() const { return frontItem == rearSpace; }
   virtual bool full()  const { return rearSpace == upperBound || frontItem == 0; }
   virtual int  size()  const { return rearSpace - frontItem; }

   virtual string popRear()
   {
   		if(empty()){
   			cerr << "Later we'll define and throw an EmptyQException" << endl;
   			return "";
   		}else {
   			return elements->at(--rearSpace);
   		}
   }

	virtual string popFront() 
	{
      if (empty()) {
         cerr << "Later we'll define and throw an EmptyQException" << endl;
         return "";
      } else {
         return elements->at(frontItem++);
      }
   }

    /** Directions include similarly testing for "full" in the C++ code.
    */
   virtual void pushFront(string newItem) 
   {
      elements->at(--frontItem) = newItem;
   }

   virtual void pushRear(string newItem) 
   {
      elements->at(rearSpace++) = newItem;
   }

   virtual string toString() 
   { 
      string out = "";
      for (int i = frontItem; i < rearSpace; i++) {
         //out = out +  elements[i] + " ";
      	out.append(elements->at(i));
      	out.append(" ");
      }
      return out;
   }
};

int main()
{
	StringDeque *sd = new StringDeque(100);
	sd->pushFront("oh");
    sd->pushFront("say");
    sd->pushFront("can");
    sd->pushFront("you");
    sd->pushFront("see");
    sd->pushRear("any");
	sd->pushRear("bad bugs");
	sd->pushRear("on");
	sd->pushRear("me?");
	cout << sd->toString() << endl;
	string pop2 = sd->popRear();
	pop2.append(" ");
	pop2.append(sd->popRear());
	cout << pop2 << ", did this print in the right order?" << endl;
	sd->pushFront("I");
	cout << "Final deque: " << sd->toString() << endl;
	return 0;
}








