/* dictlookupGS.cpp
 * Gagandip  Singh 
 * CSE 250 hw6 - 3/1/2013
*/

#import <iostream>
#include <fstream>
#import "StackPairGS.h"
#include <cmath>
#include <vector>
#include <algorithm> 

using namespace std;

static StackPair<char> *ts = new StackPair<char>(50);

string wordTurn(const string& word)
{
	string theword  =  word;
	int letterCount = theword.size();

	if (letterCount == 1)
	{
		cout << "input word must be longer than 1 letter." << endl;
		return 0;
	}

	//if letterCount is odd, the middle letter will be the new last letter
	int halfway = floor(letterCount/2);

	//push first half of the characters into stackA
	for(int i=0; i<halfway; i++){
		ts->pushA(theword[i]);
	}

	//push second half of the characters into stackA
	for(int i=halfway; i<letterCount; i++){
		ts->pushB(theword[i]);
	}

	//re-assemble 1st half
	char* newword = new char[letterCount];
	for(int i=0; i<halfway; i++){
		newword[i] = ts->popA();
	}

	//re-assemble 2nd half
	for(int i=halfway; i<letterCount; i++){
		newword[i] = ts->popB();
	}

	//cout << "the new word is " << newword << endl;
	return newword;
}

bool binsearch(const vector<string>& words, const string& word)
{
  	if (std::binary_search (words.begin(), words.end(), word)){
    	return true;
    }
    else{
    	return false;
    }
}

int main(int argc, const char* argv[])
{
	if (argc == 1 || argc > 2) //argc must == 2 (1 for progname, 1 for input-file)
	{
		cerr << "Usage: " << argv[0] << " input-file" << endl;
		return 0;
	}

	string filename = argv[1];
	
	ifstream inf(filename.c_str());
	ofstream outf("pairs.txt");
 
    if (!outf)
    {
        cout << "failed to write to pairs.txt" << endl;
        exit(EXIT_FAILURE);
    }
    if (!inf)
    {
        cout << "could not find " << filename << endl;
        exit(EXIT_FAILURE);
    }
    //ENS: top two if's ensure an infile and outfile are available

    //outf << "I am a C++ Programmer ." << endl;
    //outf << "I like C also ." << endl;
    //outf.close();

    vector<string> oldWords;
    vector<string> newWords;

    //REQ: no blank lines in input file
    while (inf)
    {
        string aWord;
        getline(inf, aWord);
        string newWord = wordTurn(aWord);
        oldWords.push_back(aWord);
        newWords.push_back(newWord);
        //cout << newWord << " added to the newWords vector" << endl;
    }
    inf.close();

    sort(oldWords.begin(), oldWords.end());
    sort(newWords.begin(), newWords.end());

    for (unsigned i=0; i<newWords.size(); i++)
    {
        //LOOP INV: nothing is changed, vectors are only being read from
    	string curr = newWords.at(i);
    	if( binsearch(oldWords,curr)){
    		outf << curr << ", " << wordTurn(curr) << endl;
    	}
    }
    outf.close();

	delete[] ts;
	return 0;
}


/* Report Questions

in binary search the vector is unsorted, so after sorting
searching the tree with log*n height takes n*log*n time

with set, O(logn) (for insertion) + O(logn) (for lookup)
summed up is O(nlogn)

with the 3rd, insertion is trivial, sorting is nlogn
and then add search (log n) so nlogn+logn is O(nlogn)

for both a & b i would not want binary search b/c its slower
then the presented methods. O(1) & O(n) < O(nlogn)

*/



