/* wordturnGS.cpp
 * Gagandip  Singh 
 * CSE 250 hw4 - 2/14/2013
*/

#import <iostream>
#import "StackPairGS.h"
#include <cmath>

using namespace std;

int main(int argc, const char * argv[])
{
	if (argc == 1 || argc > 2) //argc must == 2 (1 for progname, 1 for input-word)
	{
		cerr << "Usage: " << argv[0] << " your_word_here" << endl;
		return 0;
	}

	string theword  =  argv[1];
	int letterCount = theword.size();

	if (letterCount == 1)
	{
		cout << "input word must be longer than 1 letter." << endl;
		return 0;
	}

	//if letterCount is odd, the middle letter will be the new last letter
	int halfway = floor(letterCount/2);
	StackPair<char> *ts = new StackPair<char>(letterCount);

	//push first half of the characters into stackA
	for(int i=0; i<halfway; i++){
		ts->pushA(theword[i]);
	}

	//push second half of the characters into stackA
	for(int i=halfway; i<letterCount; i++){
		ts->pushB(theword[i]);
	}

	//re-assemble 1st half
	char* newword = new char[letterCount];
	for(int i=0; i<halfway; i++){
		newword[i] = ts->popA();
	}

	//re-assemble 2nd half
	for(int i=halfway; i<letterCount; i++){
		newword[i] = ts->popB();
	}

	cout << "the new word is " << newword << endl;
	return 0;
}



