/**
*File "DequeTestGMH.cpp" by Garrett Haima for CSE250, Spring 2013"
*This is the c++ variation of the DequeTest created by KWR.
*Can add and take away from items in the front or back of a
*que
*/

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class StringDeque {

   vector<string>* elements;
   int frontItem;   // CLASS INV: indexes item with the least index
   int rearSpace;   // CLASS INV: indexes space after item with greatest index
   int upperBound;  //For array[0..n-1] this is "n" not "n-1".

   //CLASS INV: frontSpace indicates first empty cell for pushFront
   //           rearSpace designates rear item (not space) for popRear---
   //           ---or if there is no such item, rearSpace == frontItem;
 public:
   StringDeque(int guaranteedCapacity) : elements(new vector<string>(
         2*guaranteedCapacity)), 
      frontItem(guaranteedCapacity), rearSpace(guaranteedCapacity),
      upperBound(2*guaranteedCapacity){}
   
   virtual bool isEmpty() { return frontItem == rearSpace; }
   virtual bool isFull() { return rearSpace == upperBound || frontItem==0; }
   virtual int size() { return rearSpace - frontItem; }

   virtual string popRear() {
      if(isEmpty()){
         cerr << "Later we'll define and throw an EmptyQException";
         return "";
      } else {
         return elements->at(--rearSpace);
      }
   }

   virtual string popFront(){
      if(isEmpty()){
         cerr << "Later we'll define and throw an EmptyQException";
         return "";
      } else {
         return elements->at(frontItem++);
      }
   }
   /** Directions include similarly testing for "full" in the C++ code.
    */
   virtual void pushFront(string newItem){
      elements->at(--frontItem) = newItem;
   }

   virtual void pushRear(string newItem){
      elements->at(rearSpace++) = newItem;
   }

   virtual string toString(){
      string out = "";
      for (int i = frontItem; i < rearSpace; i++){
         out += elements->at(i) + " ";
      }
      return out;
   }
};
int main(){
   StringDeque* sd = new StringDeque(100);
   sd->pushFront("oh"); 
   sd->pushFront("say");
   sd->pushFront("can");
   sd->pushFront("you");
   sd->pushFront("see");    
   sd->pushRear("any");
   sd->pushRear("bad bugs");
   sd->pushRear("on");
   sd->pushRear("me?");
   cout << sd->toString() << endl;
   string pop2 = sd->popRear() + " " + sd->popRear();
   cout << pop2 << ", did this print in the right order?" << endl;
   sd->pushFront("I");
   cout << "Final deque: " << sd->toString() << endl;
   return(0);
} 

/**
* The reason that the java and c++ codes produce different results is because
c++ does not know order when it comes to a statement while java does, so when
you are popping the rear it just grabs one of them instead of doing them in
order like we think they would.
*/
