/** File "DequeTest.java", by KWR for CSE250, Spring 2013.  For
Assignment 2.  Translate this file into equivalent C++ code.
NOTE: This is different from a similarly-titled assignment in Fall 2010.
 */

#include<iostream>
#include<string>
#include<vector>

using namespace std;
class StringDeque { //Front of deque is toward 0, but need not be 0.
   private:
   vector<string>* elements;
   int frontItem;   //CLASS INV: indexes item with least index
   int rearSpace;   //CLASS INV: indexes space after item with greatest index
   int upperBound;  //For array[0..n-1] this is "n" not "n-1".

   //CLASS INV: frontSpace indicates first empty cell for pushFront
   //           rearSpace designates rear item (not space) for popRear---
   //           ---or if there is no such item, rearSpace == frontItem;

   public:
      StringDeque(int guaranteedCapacity): 
      elements(new vector<string>(2*guaranteedCapacity)),
      frontItem(guaranteedCapacity),
      rearSpace(guaranteedCapacity),
      upperBound(2*guaranteedCapacity){};
   
   /** C++ lingo: call the first two "empty" and "full".  Remember "const"!
    */
   virtual ~StringDeque(){delete(elements);}
   virtual bool isEmpty() const { return frontItem == rearSpace; }
   virtual bool isFull() const  { return rearSpace == upperBound || frontItem == 0; }
   virtual  int size() const { return rearSpace - frontItem; }

   virtual string popRear() {
      if (isEmpty()) {
         cerr<<"Later we'll define and throw an EmptyQException"<<endl;
         return "";
      } else {
         return elements->at(--rearSpace);
      }
   }
   virtual string popFront() {
      if (isEmpty()) {
         cerr<<"Later we'll define and throw an EmptyQException"<<endl;
         return "";
      } else {
         return elements->at(frontItem++);
      }
   }

   /** Directions include similarly testing for "full" in the C++ code.
    */
   virtual void pushFront(string newItem) {
      elements->at(--frontItem) = newItem;
   }
   virtual void pushRear(string newItem) {
      elements->at(rearSpace++) = newItem;
   }


   virtual string toString() {
      string out = "";
      for (int i = frontItem; i < rearSpace; i++) {
         out += elements->at(i) + " ";
      }
      return out;
   }
};


  int main() {
      StringDeque* sdp = new StringDeque(100);
      sdp->pushFront("oh");
      sdp->pushFront("say");
      sdp->pushFront("can");
      sdp->pushFront("you");
      sdp->pushFront("see");
      sdp->pushRear("any");
      sdp->pushRear("bad bugs");
      sdp->pushRear("on");
      sdp->pushRear("me?");
      cout<<sdp->toString()<<endl;
      string pop2 = sdp->popRear() + " " + sdp->popRear();
      cout<<pop2 + ", did this print in the right order?"<<endl;
      sdp->pushFront("I");
      cout<<"Final deque: " + sdp->toString()<<endl;
   }

// the printed result is defferent on this(string pop2 = sdp->popRear() + " " + sdp->popRear();) line of code.

// JAVA print : me? on, did this print in the right order?
// C++ print: on me?, did this print in the right order?
 
// becuase java execute code from left to right, However c++ is not guarantee to execute from left to right or right to left. C++ is usually execute code from right to left.

