#include<iostream>
#include<string>
#include<vector>

using namespace std;
class StringStack {
   private:
   vector<string>* elements;
   int frontSpace;  //first free cell, after top-of-stack
   int maxAdds;

   //CLASS INV: top indicates first empty cell for pushFront

   public:
      StringStack(int maxAdds):
      elements(new vector<string>(maxAdds)),
      frontSpace(0),
      maxAdds(maxAdds){};

   virtual ~StringStack(){delete(elements);}
   virtual bool isEmpty() const { return frontSpace == 0; }
   bool isFull() const { return frontSpace == maxAdds; }
   virtual int size() const { return frontSpace; }
   virtual void pushFront(string newItem) { elements->at(frontSpace++) = newItem;}
   virtual string popFront() {
      if (isEmpty()) {
         cerr<<"We *could* define and throw an EmptyStackException"<<endl;
         return "";
      } else {
         return elements->at(--frontSpace);
      }
   }
 
   virtual string toString() {
      string out = "";
      for (int i = 0; i < frontSpace; i++) {
         out += elements->at(i) + " ";
      }
      return out;
   }
};   
   int main() {
      StringStack* sqp = new StringStack(100);
      sqp->pushFront("oh");
      sqp->pushFront("say");
      sqp->pushFront("can");
      sqp->pushFront("you");
      sqp->pushFront("see");
      cout<<sqp->toString()<<endl;
      string pop2 = sqp->popFront() + " " + sqp->popFront();
      cout<<pop2 + ", did this print in the right order?"<<endl;
      sqp->pushFront("me?");
      cout<<"Final stack: " + sqp->toString()<<endl;   
   }

