/**ChainClientJH.cpp by Jimmy Huang for CSE250 Spring '14
*/

#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <sstream>
#include <stdlib.h>
#include "StringWrap.h"
#include "PeekDequeTemplateJH.h"

using namespace std;

bool hd1(const string& x,const string& y){
  if (x.size() != y.size()) { return false; }
  int count = 0;
  for (size_t i = 0; i < y.size(); i++) {
    if (x.at(i) != y.at(i)) { count++; }
  }
  return count == 1; 
}

bool xd1(const string& lhs, const string& rhs) {
  if (lhs.size() == rhs.size()) {
    return hd1(lhs,rhs);
  } else if (lhs.size() == 1 + rhs.size()) {
    return hd1(lhs, rhs + char('\0')) || hd1(lhs, char('\0') + rhs);
  } else if (1 + lhs.size() == rhs.size()) {
    return hd1(lhs + char('\0'), rhs) || hd1(char('\0') + lhs, rhs);
  } else {
    return false; //strings differ by 2 or more in length.
  }
}

bool ed1(const string& xt, const string& yt){        //Check for valid pair of words
  string x = xt;
  string y = yt;
  if (xt.size() < yt.size()){        //If first word is < second word swap them
    x = yt;
    y = xt;
  }
  if((x.size() != y.size()) && (x.size()-1 != y.size())){        //If both words are not the same size and has a change of more then one return false
    return false;
  }
  for (size_t i = 0; i < x.size(); i++){        //Loop through each letter in word
    if (x[i] != y[i]){        //Finding changes in letter
      for (size_t j = i; j < x.size(); j++){        //Loop through rest of word
        if (x.size() == y.size()){        //Checks if size is the same
          if (x[j+1] != y[j+1]){        //Check for similarity in rest of both words and return true
            return false;
          }
        }
        else if (x[j+1] != y[j]){        //Checking remaing letters in word for similarty after one change found and return true
          return false;
        }
      }
      return true;
    }
  }
  return false;
}

/**string firstPeek(peekDeque<StringWrap>* stack){        //Get the first word to check
return stack->peek().str();
}

string secondPeek(peekDeque<StringWrap>* stack){        //Get the second word to check
stack->moveRearWard();
return stack->peek().str();
}*/

bool legalTest(peekDeque<StringWrap>* stack){        //Check if entire chain in stack is legal
  if (stack->empty()){        //Stack is empty give error
    cerr << "Deque is empty nothing to check" << endl;
    return false;
  }
  else if (stack->size() == 1){        //Check if there is more then one word to test
    cerr << "Deque has size 1, 2 or more required for a legal chain" << endl;
    return false;
  }
  else {
    string word;
    stack->indexFront();
    string prevWord = stack->peek().str();
    stack->moveRearWard();
    while (!(stack->atRear())){
      word = stack->peek().str();
      if (!ed1(prevWord,word)){
        return false;
      }
      prevWord = word;
      stack->moveRearWard();
    }
  }
  return true;
}

int main(int argc, char** argv){
  string infileName = "words.txt";
  ifstream* INFILEp = new ifstream(infileName.c_str(), ios_base::in);
  if (argc >= 2) {   //means filename argument was given
    infileName = argv[1];
    INFILEp = new ifstream(infileName.c_str(), ios_base::in);
    //note: it is not allowed to reassign a value stream that way
  }
  if (!INFILEp){        //Check if file exist
    cerr << "File not found!" << endl;
    return 1;
  }

  //peekDeque<StringWrap>* pd = new peekDeque<StringWrap>(100);        //Create the stackDeque

  vector<peekDeque<StringWrap>*> deques;
  deques.push_back(new peekDeque<StringWrap>(100));

  string word;
  int noCount = 0;                    //No command line argument for debuging
  int wordCount = 0;                    //Command line argument given for debugging
  int *wordCountP = &noCount;                    //Used to keep track of debugging command
  int arg = 1;                    //Used to keep track of debugging commang
  if (argc >= 3){                    //Command line argumnet was given
    arg = atoi(argv[2]);
    wordCountP = &wordCount;
  }
  while (((*INFILEp) >> word) && (*wordCountP < arg)){                    //Get word from file
    if (word.size() > 2){                    // word has a size bigger then 2
      StringWrap SW = StringWrap(word);
      SW.trimNonAlpha();                    //Trims all non alphas from word
      SW.makeLower();                    //Makes SW lowercase
      wordCount++;                    //Tracks how much word has already been done for debugging
      if (SW.isAlpha()){                    //Word is a non-alpha
        bool check = true;                    //Holds if a if statment ha run  or not
        bool noCopy = true;                    //Tracks if there is a duplicate word for creating a new deque
        for (size_t i = 0; i < deques.size(); i++){                    //Go through all deques
          //int i = 0;
          if(deques[i]->full()){                    //Create new deque if current is full
            deques.push_back(new peekDeque<StringWrap>(100));
            deques[i+1]->pushFront(SW);
            deques[i+1]->indexFront();
            i++;
            check = false;
          }
          else if (deques[i]->empty()){                    //push first word in deque
            deques[i]->pushFront(SW);
            deques[i]->indexFront();
            check = false;
          }
          else if (deques[i]->size() >= 2){                    //Makes sure there si two word in deque
            deques[i]->moveRearWard();
            string checker = deques[i]->peek().str();
            deques[i]->indexFront();
            if (checker != SW.str() && ed1(deques[i]->peek().str(),SW.str())){                    //checks if current word is the same as word before peek and is "ed1" holds true for front
              deques[i]->pushFront(SW);
              deques[i]->indexFront();
              check = false;
            }
            if  (check){                    //used to set peek to rear
              deques[i]->indexRear();
              deques[i]->moveFrontWard();
              checker = deques[i]->peek().str();
              deques[i]->indexRear();
              if (checker != SW.str() && ed1(deques[i]->peek().str(),SW.str())){                    //checks if current word is the same as word before peek and is "ed1" holds true for rear
                deques[i]->pushRear(SW);
                deques[i]->indexFront();
                check = false;
              }
              else {
                deques[i]->indexFront();
              }
            }
          }
          else if (check && ed1(deques[i]->peek().str(),SW.str())){                    //Push second word in to deque
            deques[i]->pushFront(SW);
            deques[i]->indexFront();
            check = false;
          }
          if (check && (i == deques.size()-1)){                    //current deque is last deque
            for (size_t j = 0; j < deques.size(); j++){
              deques[j]->indexFront();
              if (SW.str() == deques[j]->peek().str()){
                noCopy = false;
              }
            }
            if (noCopy){                    //Creating new deque for word
              deques.push_back(new peekDeque<StringWrap>(100));
              deques[i+1]->pushFront(SW);
              deques[i+1]->indexFront();
              i++;
            }
          }
        }
      }
    }
  }

  /**  for (size_t i = 0; i < deques.size(); i++){
  if (deques[i]->size() > 10){
  cout << deques[i]->toString() << endl;
  cout << "-----------------------------------------------------------------------" << endl;
  }
  }*/

  size_t longestChain = 0;
  for (size_t i = 0; i < deques.size(); i++){
    if (deques[i]->size() > deques[longestChain]->size()){
      longestChain = i;
    }
  }
  cout << "-*-Longest Chain(s)-*-" << endl;
  cout << deques[longestChain]->toString() << endl;
  cout << "-----------------------------------------------------------------------" << endl;
  for (size_t i = 0; i < deques.size(); i++){
    if (i != longestChain && deques[i]->size() > deques[longestChain]->size()- 2){
      cout << deques[i]->toString() << endl;
      cout << "-----------------------------------------------------------------------" << endl;
    }
  }

  int longestWord = 0;
  size_t longestWordChain;
  for (size_t i = 0; i < deques.size(); i++){
    deques[i]->indexFront();
    while (!deques[i]->atRear()){
      deques[i]->moveRearWard();
      if (deques[i]->peek().size() > longestWord){
        longestWord = deques[i]->peek().size();
        longestWordChain = i;
      }
    }
  }
  cout << "-*-Chain with the longest Word-*-" << endl;
  cout << deques[longestWordChain]->toString() << endl;

  //cout << legalTest(deques[0]) << endl;        //Print out if the chain is legal
  INFILEp->close();

  for (size_t i = 0; i < deques.size(); i++){
    delete(deques[i]);
  }

  return 0;
}
/** For each chain i have it push the first two words in that qualify "ed1" and then for each other word it will check if it duplicates the word before the peek and if it qualify "ed1" then push front or rear and if not create a new deque after checking if the current word is the same as a word currently at the peek of any deque.

For the longest chain i just compared the size of each deque and for the longest word chain i went though every deque and found the longest word and kept track of that deque and printed it out the end.
*/