/**File "DequeTestJH.cpp", By JH for CSE250*/

#include <iostream>
#include <vector>
#include <string>

using namespace std;

class stringDeque{
vector<string>* elements;
int frontItem;
int rearSpace;
int upperBound;
int* frontItemP;
int* rearSpaceP;
int* upperBoundP;

public:
	stringDeque(int guaranteedCapacity) : elements(new vector<string>(guaranteedCapacity*2)){
                frontItemP = &frontItem;
		rearSpaceP = &rearSpace;
		upperBoundP = &upperBound;
		frontItem = guaranteedCapacity;
		rearSpace = guaranteedCapacity;
		upperBound = guaranteedCapacity*2;
	}
	virtual ~stringDeque() {delete(elements);}

	virtual bool const empty(){
                return (*frontItemP == *rearSpaceP);
        }

	virtual bool const full(){
                return (*rearSpaceP == *upperBoundP || *frontItemP == 0);
        }

	virtual int size(){
                return (*rearSpaceP - *frontItemP);
        }

	virtual string popRear(){
                if (empty()){
		cout << "Later we'll define and throw an EmptyQException" << endl;
                        return ("");
                }
                else {
                        return (elements->at(--*rearSpaceP));
                }
        }

	virtual string popFront(){
                if (empty()){
                        cout << "Later we'll define and throw an EmptyQException" << endl;
                        return ("");
                }
                else {
                        return (elements->at((*frontItemP)++));
                }
        }

	virtual void pushFront(string newItem){
                elements->at(--*frontItemP) = newItem;
        }

	virtual void pushRear(string newItem){
                elements->at((*rearSpaceP)++) = newItem;
        }

	virtual string toString(){
                string out = "";
                for (int i = *frontItemP; i < *rearSpaceP; i++){
                out+=elements->at(i)+" ";
                }
        return out;
        }

};

int main(){
	stringDeque* sd = new stringDeque(100);
	sd->pushFront("oh");
	sd->pushFront("say");
        sd->pushFront("can");
        sd->pushFront("you");
        sd->pushFront("see");
	sd->pushRear("any");
        sd->pushRear("bad bugs");
        sd->pushRear("on");
        sd->pushRear("me?");
	cout << sd->toString() << endl;
	//string pop2 = sd->popRear() + " " + sd->popRear();
	string pop2 = sd->popRear() + " ";
	pop2+=sd->popRear();
	cout << pop2 << ", did this print in the right order?" << endl;
	sd->pushFront("I");
	cout << "Final deque: " << sd->toString() << endl;
	return(0);
}

/**
In Java the popRear popped bottom up "me? on" where C++ printed "on me?". I found that it is caused by the way the compiler evaluates the line when more then one method is called on a single line.I have corrected it.
*/
