/** File "FlexClientJH.cpp", by KWR for CSE250, Spring 2014(Edited by JH for Assignment 7 CSE250, SPR12)
    Assignment 5 answer.  Has lines that can be edited to implement
    various strategies.  As released on 4/18/14, it relies on accessor
    methods "front()" and "rear()" to implement the strategy of avoiding
    immediate repetitions, /and/ also "front2nd()" and "rear2nd()" to
    avoid switchback repetitions like "hip hop hip hop hip...".
    Hence if you use this client, you will need to adapt these methods.
 */

#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <sstream>

#include <cmath>
#include "StringWrap.h"
#include "StringWrap.cpp"  //to bypass makefile for simplicity
#include "FlexArrayIJH.h"
//#include "Deque2Flex.h"
//#include "Deque2FlexI.h"

using namespace std;

///*----------------------------------------------------
bool ed1(const string& x, const string& y) {
   int xleft = 0; int yleft = 0;
   int xright = x.length() - 1; int yright = y.length() - 1;
   while (xleft <= xright && yleft <= yright && x[xleft] == y[yleft]) {
      xleft++; yleft++;
   }
   //Control here means all chars have matched on LHS up to xleft,yleft.
   //If one has gone off the string, accept iff other's length is 1 more.
   if (xleft > xright) { 
      return (xleft == yright);  //INCLUDES case x == y, return false.
   } 
   if (yleft > yright) {
      return (yleft == xright);
   }
   //Control here means we have a mismatched character

   while (xright >= xleft && yright >= yleft && x[xright] == y[yright]) {
      xright--; yright--;
   }
   return (xright <= xleft && yright <= yleft);
}
//----------------------------------------------------*/
/*-----------------------------------------------------
bool ed1(const string& x, const string& y) {
   int xlen = x.length(); int ylen = y.length();
   if (fabs(double(xlen - ylen)) >= 2) { return false; }
   if (xlen == ylen) {
      int count = 0;
      for (int i = 0; i < xlen; i++) {
         if (x[i] != y[i]) { count++; }
      }
      return (count == 1);
   } else if (xlen == ylen + 1) {
      for (int i = 0; i < ylen; i++) {
         if (x[i] != y[i]) { 
            return (x.substr(i+1) == y.substr(i));
         }
      } //all-match means erase last char  in x.
      return true;
   } else {   //ylen == xlen + 1
     for (int i = 0; i < xlen; i++) {
         if (x[i] != y[i]) { 
            return (y.substr(i+1) == x.substr(i));
         }
      } //all-match means erase last char  in y.
      return true;
   }
}
--------------------------------------------------------*/

/** True if switching 2 adjacent unequal letters in x leaves y.
 */
bool transpose(const string& x, const string& y) {
   if (x.length() != y.length()) { return false; }
   // else
   int xlenm1 = x.length() - 1;
   for (int i = 0; i < xlenm1; i++) {
      if (x[i] != y[i]) {
         if (x[i] == y[i+1] && x[i+1] == y[i] && x[i] != x[i+1]
                  && x.substr(i+2) == y.substr(i+2)) {
            cout << "transpose relevant for x = " << x << ", y = " << y << endl;
            return true;
         } else {
            return false;
         }
      }
   } //control here means x == y
   return false;
}

/** Damerau's distance-one criterion, typos correctable by 1 edit.
 */
bool dd1(const string& x, const string& y) {
   return ed1(x,y) || transpose(x,y);
}
      
int main(int argc, char** argv) {
   // transfer command-line arguments to string array
   // remember unlike Java the executable name is the first argument
   //
   vector<string>* args = new vector<string>(argc);
   for (int i = 0; i < argc; i++) {
      args->at(i) = *(argv + i);         //equivalent to argv[i]
   }

   istringstream INS;
   int n = 10000;                        // arbitrary default value
   string INFILEName;                    // no default for file name.
   ifstream* INFILEp;

   if (argc >= 3) {                      // numerical argument "n" exists
      INS.str(args->at(2));              // safe since argc >= 3
      if (INS >> n) {
         //OK
      } else {
         cerr << "Second argument given but not a valid integer" << endl;
         return(1);
      }
   }
   if (argc >= 2) {   //note that this is *not* an "else" of the first "if"
      INFILEName = args->at(1);
      INFILEp = new ifstream(INFILEName.c_str(), ios_base::in);
      if (! INFILEp->is_open()) {
         cerr << "Unable to open file: " << INFILEName << endl;
         return(1);
      }
   } else {    // argc == 1, i.e. no arguments given
      cerr << "Usage: " << args->at(0) << " file n    with n >= 0" << endl;
      return(1);
   }

   //Deque<StringWrap>* sq = new Deque<StringWrap>(100);

   //cout << "ed1(the,the) is " << ed1("the","the") << endl;

   FlexArray<FlexArray<StringWrap>*>* flex = new FlexArray<FlexArray<StringWrap>*>();
   //held by pointer

   int numItems = 0;
   string word;
   while((*INFILEp) >> word && numItems < n) {
      numItems++;   
      bool attachedWord = false;
      //StringWrap* swp = new StringWrap(word);  //Not recommended here
      StringWrap sw(word);
      sw.trimNonAlpha();
      sw.makeLower();
      if (!(sw.size() > 2)) {   // && sw.isAlpha())) {
         continue;
      }
      word = sw.str();
      for (size_t i = 0; i < flex->size(); i++) {
         FlexArray<StringWrap>* sq = flex->at(i);
		 StringWrap rear = *sq->rBegin();
		 StringWrap front = *sq->begin();
		 StringWrap rear2nd = *sq->rBegin()++;
		 StringWrap front2nd = *sq->begin()++;
         bool wordPresent = false;
          for (FlexArray<StringWrap>::iterator it=sq->begin();it != sq->end();++it){
          StringWrap swIt = *it;
		  if (swIt.str() == sw.str()){
              wordPresent = true;
			  break;
            }
          }
		bool insertMid = false;
		FlexArray<StringWrap>::iterator it=sq->begin();
		  while (it != sq->rBegin()){
		  StringWrap swIt = *it;
		  ++it;
		  StringWrap swIt2 = *it;
		  if (transpose(swIt.str(),sw.str()) || (ed1(swIt.str(),sw.str()) && ed1(swIt2.str(),sw.str()))){
			insertMid = true;
			break;
		  }
		  }
         attachedWord = attachedWord || wordPresent;
         if (sq->empty()) {
            sq->insert(sq->begin(),sw);
            attachedWord = true;
         } else if ((!wordPresent) && insertMid){
		     sq->insert(it,sw);
			 attachedWord = true;
		 } else if ((!wordPresent) && dd1(sw.str(),front.str())) {
            //if (word.size() >= sq->front().str().size()) 
            {
               sq->insert(sq->begin(),sw);
               attachedWord = true;
            }
         } else if ((!wordPresent) && dd1(sw.str(),rear.str())) {
            //if (word.size() >= sq->rear().str().size()) 
            {
               sq->insert(sq->end(),sw);
               attachedWord = true;
            }
         } //else move on
      }
      if (!attachedWord) {   //start a new chain with the word
         FlexArray<StringWrap>* sq = new FlexArray<StringWrap>();
         sq->insert(sq->begin(),sw);
         flex->insert(flex->begin(),sq);
      }
   }

   //now test state of stream upon termination

   if (INFILEp->eof()) {
      cout << "Read all " << numItems << " whitespace-separated items"
           << " in file " << INFILEName << endl;
   } else if (INFILEp->bad()) {
      cerr << "Unrecoverable i/o error, sorry, after " << numItems
           << " items." << endl;
   } else {
      // POST: stream is still good, so we must have hit n items
      cout << "Read " << numItems << " whitespace-separated items from file "
           << INFILEName << endl;
   }

   //Now find longest chain; choose first of equal-length ones.

   int indexLongestChain = -1;
   size_t longestChainLength = 0;
   size_t longestWordLength = 0;
   int indexLongestWord = -1;
   size_t minflexize = 2; //min chain length for longest word consideration
   for (size_t i = 0; i < flex->size(); i++) {
      if (flex->at(i)->size() > longestChainLength) {
         indexLongestChain = i;
         longestChainLength = flex->at(i)->size();
      }
	  FlexArray<StringWrap>::iterator swIt = flex->at(i)->begin();
      while (swIt != flex->at(i)->end()) {
         StringWrap sw2 = *swIt;
         if (sw2.size() > longestWordLength
                        && flex->at(i)->size() >= minflexize)
         {
            longestWordLength = sw2.size();
            indexLongestWord = i;
         }
         swIt++;  //easy to forget
      }
   }
   cout << "Results with strategy of forbidding both immediate and alternating repetitions,"
        << endl << "and allowing shorter words to be attached to longer ones." << endl;
   if (indexLongestChain > -1) {
      cout << "Longest chain: " + flex->at(indexLongestChain)->toString()
           << endl;
   }
   if (indexLongestWord > -1) {
      cout << "Chain with longest word: " 
           << flex->at(indexLongestWord)->toString() << endl;
   }
   for (size_t k = 0; k < flex->size(); k++) {
      delete(flex->at(k));
   }
   INFILEp->close();

   return 0;
}

/**
1) To find the longest word with code given by KWR changing it to iterate through FlexArray of each FlexArray to find the longest word and returning it. I think it had the same difficulty.

2) After changing the code from Vector to FlexArray i got about hte sam time for runs.
*/
