/**File "DequeTestJH.cpp", By JH for CSE250*/

#include <iostream>
#include <vector>
#include <string>

using namespace std;

class stringDeque{
protected:
vector<string>* elements;
int frontItem;
int rearSpace;
int upperBound;
int* frontItemP;
int* rearSpaceP;
int* upperBoundP;

public:
	stringDeque(int guaranteedCapacity) : elements(new vector<string>(guaranteedCapacity*2)){
                frontItemP = &frontItem;
		rearSpaceP = &rearSpace;
		upperBoundP = &upperBound;
		frontItem = guaranteedCapacity;
		rearSpace = guaranteedCapacity;
		upperBound = guaranteedCapacity*2;
	}
	virtual ~stringDeque() {delete(elements);}

	virtual bool const empty(){
                return (*frontItemP == *rearSpaceP);
        }

	virtual bool const full(){
                return (*rearSpaceP == *upperBoundP || *frontItemP == 0);
        }

	virtual int size(){
                return (*rearSpaceP - *frontItemP);
        }

	virtual string popRear(){
                if (empty()){
		  cout << "Later we'll define and throw an EmptyQException" << endl;
		  return ("");
                }
                else {
                        return (elements->at(--*rearSpaceP));
                }
        }
  
	virtual string popFront(){
                if (empty()){
                        cout << "Later we'll define and throw an EmptyQException" << endl;
                        return ("");
                }
                else {
                        return (elements->at((*frontItemP)++));
                }
        }

	virtual void pushFront(string newItem){
                elements->at(--*frontItemP) = newItem;
        }

	virtual void pushRear(string newItem){
                elements->at((*rearSpaceP)++) = newItem;
        }

	virtual string toString(){
                string out = "";
                for (int i = *frontItemP; i < *rearSpaceP; i++){
                out+=elements->at(i)+" ";
                }
        return out;
        }
};

class peekDeque : public stringDeque{
int peekIndex;
int* peekIndexP;

public:
  peekDeque(int guaranteedCapacity):stringDeque(guaranteedCapacity){
    peekIndexP = &peekIndex;
  }
  
  virtual string peek(){
     if (empty()){
      cout << "Later we'll define and throw an EmptyQException" << endl;
      return ("");
    }
    else {
      return elements->at(*peekIndexP);
    }
  }

  virtual void moveFrontWard(){
    if (empty()){
      cout << "Later we'll define and throw an EmptyQException" << endl;
    } 
    if (*peekIndexP == (*frontItemP)) {
      cout << "You have hit the top of the deque" << endl;
    }
    else {
      --*peekIndexP;
    }
  }

  virtual void moveRearWard(){
    if (empty()){
      cout << "Later we'll define and throw an EmptyQException" << endl;
    } 
    if (*peekIndexP == (*rearSpaceP-1)){
      cout << "You have hit the bottom of the deque" << endl;
    }
    else {
      ++*peekIndexP;
    }
  }
			
	 virtual void pushFront(string newItem){
                elements->at(--*frontItemP) = newItem;
        	*peekIndexP = *frontItemP;
	}

        virtual void pushRear(string newItem){
                elements->at((*rearSpaceP)++) = newItem;
        }


  virtual string popRear(){
    if (empty()){
      cout << "Attempt to pop from empty PeekDeque." << endl;
      return ("");
    }
    else {
      return (elements->at(--*rearSpaceP));
    }
  }

  virtual string popFront(){
    if (empty()){
      cout << "Attempt to pop from empty PeekDeque." << endl;
      return ("");
    }
    else {
      return (elements->at(*frontItemP++));
    }
  }
};

int main(){
	//stringDeque* sd = new stringDeque(100);
	peekDeque* pd = new peekDeque(100);
	pd->pushFront("oh");
	pd->pushFront("say");
        pd->pushFront("can");
        pd->pushFront("you");
        pd->pushFront("see");
	pd->pushRear("any");
        pd->pushRear("bad bugs");
        pd->pushRear("on");
        pd->pushRear("me?");
        //cout << pd->toString() << endl;
        ////string pop2 = sd->popRear() + " " + sd->popRear();
        //string pop2 = pd->popRear() + " ";
        //pop2+=pd->popRear();
        //cout << pop2 << ", did this print in the right order?" << endl;
        //pd->pushFront("I");
        //cout << "Final deque: " << pd->toString() << endl;
	cout << pd->peek() << endl;
	pd->moveFrontWard();
	cout << pd->peek() << endl;
	pd->moveRearWard();
	pd->moveRearWard();
	cout << pd->peek() << endl;
	pd->moveRearWard();
	pd->moveFrontWard();
        cout << pd->peek() << endl;
        pd->moveRearWard();
        pd->moveRearWard();
        pd->moveRearWard();
        pd->moveRearWard();
        pd->moveRearWard();
        pd->moveRearWard();
        pd->moveRearWard();
        cout << pd->peek() << endl;
	//cout << pd->peek() << endl;
	//pd->moveFrontWard();
	//pd->moveFrontWard();
	//cout << pd->peek() << endl;
        cout << "Printing words thats start with s" << endl;
	while (!pd->empty()){
	  string check = pd->popRear();
	  if (check[0] == *"s"){
	    cout << check << endl;
	  }
	}
	return(0);
}

/**
In Java the popRear popped bottom up "me? on" where C++ printed "on me?". I found that it is caused by the way the compiler evaluates the line when more then one method is called on a single line.I have corrected it.
*/
