/**PeekDequeTemplateJH.h by Jimmy Huang for CSE250 Spring '14*/

#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <sstream>

using std::vector;
using std::endl;
using std::cerr;
using std::ostringstream;
using std::string;
using std::cout;

template <typename T>
class peekDeque;

template <typename T>
class deque{
  friend class peekDeque<T>;
  vector<T>* elements;
  int frontItem;
  int rearSpace;
  int upperBound;

public:
  explicit deque(int guaranteedCapacity) : elements(new vector<T>(guaranteedCapacity*2)){
    frontItem = guaranteedCapacity;
    rearSpace = guaranteedCapacity;
    upperBound = guaranteedCapacity*2;
  }

  virtual ~deque(){delete(elements);}

  virtual bool const empty(){return (frontItem == rearSpace);}

  virtual bool const full(){return (rearSpace == upperBound || frontItem == 0);}

  virtual int size(){return (rearSpace - frontItem);}

  virtual T popRear(){
    if (empty()){
      cerr << "Can not pop from an empty stack!" << endl;
      return T();
    }
    else {
      return (elements->at(--rearSpace));
    }
  }

  virtual T popFront(){
    if (empty()){
      cerr << "Can not pop from an empty stack!" << endl;
      return T();
    }
    else {
      return (elements->at(frontItem++));
    }
  }

  virtual void pushFront(T newItem){
    if (full()){
      cerr << "Deque is full at front" << endl;
    }
    else{
      elements->at(--frontItem) = newItem;
    }
  }

  virtual void pushRear(T newItem){
    if (full()){
      cerr << "Deque is full at front" << endl;
    }
    else{
      elements->at((rearSpace)++) = newItem;
    }
  }

  virtual string toString(){
    ostringstream OUT;
    for (int i  = frontItem; i < rearSpace; i++){
      OUT << elements->at(i) << " ";
    }
    return OUT.str();

    //string out = "";
    //for (int i = frontItem; i < rearSpace; i++){
    //       out += elements->at(i) + " ";
    //}
    //return out;
  }
};

template <class T>
class peekDeque : public deque<T>{

  int peekIndex;

public:
  explicit peekDeque(int guaranteedCapacity):deque<T>(guaranteedCapacity){
    peekIndex = this->frontItem;
  }

  virtual ~peekDeque<T>(){}

  virtual void indexFront(){
    peekIndex = this->frontItem;
  }

  virtual void indexRear(){
    peekIndex = this->rearSpace-1;
  }

  virtual bool atRear(){
    return peekIndex == this->rearSpace;
  }

  virtual T peek(){        //Peeks the Deque with peekIndex on frontSpace
    if (this->empty()){
      cerr << "Deque is empty!" << endl;
      return T();
    }
    else {
      return this->elements->at(peekIndex);
    }
  }

  virtual void moveFrontWard(){
    if (this->empty()){
      cerr << "Deque is empty!" << endl;
    }
    if (peekIndex == (this->frontItem)) {
      cout << "You have hit the top of the deque" << endl;
    }
    else {
      --peekIndex;
    }
  }


  virtual void moveRearWard(){
    if (this->empty()){
      cerr << "Deque is empty!" << endl;
    }
    if (peekIndex == (this->rearSpace)){
      cout << "You have hit the bottom of the deque" << endl;
    }
    else {
      ++peekIndex;
    }
  }

  virtual T popRear(){
    if (this->empty()){
      cerr << "Attempt to pop from empty deque." << endl;
      return T();
    }
    else {
      return deque<T>::popRear();
    }
  }

  virtual T popFront(){
    if (this->empty()){
      cerr << "Attempt to pop from empty deque." << endl;
      return T();
    }
    else {
      return deque<T>::popFront();
    }
  }
};
