#include "userBaseJH.cpp"
#include "movieBaseAH.cpp"
#include <vector>
#include <string>
#include <algorithm>

using namespace std;

struct topMovie{
  size_t movieId;
  string movieName;
  double topRate;

  topMovie(size_t mov,string mName,double topR)
    : movieId(mov),movieName(mName),topRate(topR)
   { }
};

ostream& operator<<(ostream& OUT, const topMovie r) {
   OUT << r.movieId << " \"" << r.movieName << "\": " << r.topRate;
   return OUT;  //needed to piggy-back usages.
}

bool compTopRatings(const topMovie& r1,
                    const topMovie& r2) {
  return r1.topRate < r2.topRate;
}

vector<string> topRated(userBase users, movieBase movies,size_t user,int k){
  vector<string> topK;
  vector<topMovie> topMovies;
    pair<size_t,double> topPref;
  for(int i = 1; i<=users.users[user].pref.size();i++){
    topPref.second = users.users[user].pref[i];
    if (users.users[user].pref[i] < users.get_user(user).pref[i+1]){
      topPref.second = users.users[user].pref[i+1];
    }
  }
  for(int i = 1;i<users.users[user].pref.size();i++){
    if(users.users[user].pref[i]==topPref.second){
      topPref.first=i;
    }
  }
  for(vector<movie>::iterator it = movies.movieInfo.begin();it != movies.movieInfo.end();++it){
    for(vector<size_t>::iterator gIt = it->movieGenre.begin();gIt != it->movieGenre.end();++gIt){
      if (*gIt==topPref.first){
        double factor = it->avg * topPref.second;
        topMovies.push_back(topMovie(it->movieIndex,it->movieTitle,factor));
      }
    }
  }
  sort(topMovies.begin(),topMovies.end(),compTopRatings);
  for (int i = 0;i<k;i++){
    for(vector<topMovie>::reverse_iterator kIt = topMovies.rbegin();kIt != topMovies.rend();++kIt){
    topK.push_back(kIt->movieName);
    }
  }
  return topK;
}

int main(){
  userBase users;
  movieBase movies;
  for(int i = 0; i < users.users.size();i++){
    vector<string> topK = topRated(users,movies,i,10); //top 10
    for(int j = 0;j < topK.size();j++){
      cout << topK[j] << " ";
    }
  }
  return 0;
}