


#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <sstream>
//Author: Mengpei Hu
//Assignment 5:Template file
//#include <cmath>   //for fabs

using std::vector;
using std::endl;
using std::cerr;
using std::ostringstream;
using std::string;
using std::cout;

template <class T>
class PeekDeque;

template <class T>
class Deque {
   //friend class PeekDeque<T>;

   vector<T>* elements;
   int rearSpace;
   int frontItem;
   int upperBound;

   //CLASS INV: frontSpace indicates first empty cell for pushFront
   //           rearItem designates rear item (not space) for popRear---
   //           ---or if there is no such item, rearItem == frontSpace;

 public: 
   friend class PeekDeque<T>;
   explicit Deque<T>(int guaranteedCapacity) 
    : elements(new vector<T>(2*guaranteedCapacity)),
      frontItem(guaranteedCapacity),
      rearSpace(guaranteedCapacity),
      upperBound(2*guaranteedCapacity) 
   { }
   Deque<T>(const Deque<T>& other) : frontItem(other.frontItem), rearSpace(other.rearSpace),elements(new vector<T>(*(other.elements))){}
   
   virtual ~Deque<T>() { delete elements; //cout << "It's Deque Season!" << endl;
   }
   virtual Deque<T>& operator= (const Deque<T> other){
      delete elements;
      elements = new vector<T>(*(other.elements));
      frontItem = other.frontItem;
      rearSpace = other.rearSpace;
   }
   virtual bool empty() const { return frontItem == rearSpace; }

   virtual bool full() const { return rearSpace == upperBound; }

   virtual size_t size() const { return rearSpace - frontItem; }

   virtual void pushFront(T newItem) {
      if (full()) {
         cerr << "Are you playing with a full Deque?" << endl;
         cerr << toString() << endl;
      } else {
         elements->at(--frontItem) = newItem;
      }
   }

   virtual void pushRear(T newItem) {
      if (full()) {
         cerr << "Are you playing with a full Deque?" << endl;
         cerr << toString() << endl;
      } else {
         elements->at(rearSpace++) = newItem;
      }
   }

   virtual T popFront() {
      if (empty()) {
         cerr << "Too lazy to throw an EmptyDequeException." << endl;
         return T();
      } else {
         return elements->at(frontItem++);
      }
   }

   virtual T popRear() {
      if (empty()) {
         cerr << "Too lazy to throw an EmptyDequeException." << endl;
         return T();
      } else {
         return elements->at(--rearSpace);  //translates Java "next()"
      }
   }

   virtual string toString() const { 
      //ostringstream OUT;
      string out = "";
      for (int i = frontItem; i < rearSpace; i++) {
         out += elements->at(i).str() + " ";
        // OUT << elements->at(i) << " ";
      }
      return out;
      //return OUT.str();
   }

};


template <class T>
class PeekDeque : public Deque<T> {

   int peekIndex;

 public:

   explicit PeekDeque<T>(int guaranteedCapacity)
    : Deque<T>(guaranteedCapacity), peekIndex(this->frontItem) { }
   PeekDeque<T>(const PeekDeque<T>& other) : Deque<T>(other), peekIndex(other.peekIndex){}
   virtual ~PeekDeque<T>() {// cerr << "No peeking..."; 
   } //automatically calls ~Deque()

   virtual void moveFrontward() {
      if(peekIndex==this->frontItem){cerr<<"can not move frontward any more.";}
      else{ peekIndex--; }
   }

   virtual void moveRearward() {  
     if(peekIndex==this->rearSpace){cerr<<"can not move rearward any more.";}
     else{ peekIndex++; }
   }
   virtual T peek() const { return this->elements->at(peekIndex); }

   virtual T popFront() { 
      if (this->empty()) { cerr << "Pop attempt from empty PeekDeque" << endl; }
      else return Deque<T>::popFront();
   }

   virtual T popRear() {
      if (this->empty()) { cerr << "Pop attempt from empty PeekDeque" << endl; }
      else return Deque<T>::popRear();
   }

   //Extra functionality
   //virtual void pushFront(T newitem){return Deque<T>::pushFront();}
   
   //virtual void pushRear(T newitem){return Deque<T>::pushRear();}

   virtual void setPeekToFront() { peekIndex = this->frontItem; }

   virtual bool atRear() const { return peekIndex == this->rearSpace; }
   
   virtual int printIndex(){return this->peekIndex;}
  
   virtual int printFrontItem(){return this->frontItem;}
  
   virtual int printRearSpace(){return this->rearSpace;}
 
   
};   
     

