/** File "DequeTest.java", by KWR for CSE250, Spring 2013.  For 
Assignment 2.  Translate this file into equivalent C++ code.
NOTE: This is different from a similarly-titled assignment in Fall 2010.
 */
//by Mengpei Hu translated to C++ code. 
//import java.io.*;


/*
Assignment 3
Author:Mengpei Hu
id#:50048494
*/
#include<iostream>
#include<string>


using namespace std;

class StringDeque { //Front of deque is toward 0, but need not be 0.

protected:
   string* elements;
   int frontItem;   //CLASS INV: indexes item with least index
   int rearSpace;   //CLASS INV: indexes space after item with greatest index
   int upperBound;  //For array[0..n-1] this is "n" not "n-1".

   //CLASS INV: frontSpace indicates first empty cell for pushFront
   //           rearSpace designates rear item (not space) for popRear---
   //           ---or if there is no such item, rearSpace == frontItem;

   public:
      StringDeque(int guaranteedCapacity): elements(new string[2*guaranteedCapacity]), frontItem(guaranteedCapacity), rearSpace(guaranteedCapacity), upperBound(2*guaranteedCapacity){}
   /** C++ lingo: call the first two "empty" and "full".  Remember "const"!
    */
   const bool isEmpty() { return frontItem == rearSpace; }
   const bool isFull() { return rearSpace == upperBound || frontItem == 0; }
   int size() { return rearSpace - frontItem; }
   
   virtual string popRear() {
      if (isEmpty()) {
         cout<<("Later we'll define and throw an EmptyQException");
         return "";
      } else {
         return elements[--rearSpace];
      }
   }
   virtual string popFront() {
      if (isEmpty()) {
         cout<<("Later we'll define and throw an EmptyQException");
         return "";
      } else {
         return elements[frontItem++];
      }
   }

   /** Directions include similarly testing for "full" in the C++ code.
    */
   virtual void pushFront(string newItem) {
      elements[--frontItem]= newItem;
   }
   virtual void pushRear(string newItem) {
      elements[rearSpace++] = newItem;
   }


   virtual string toString() { 
      string out = "";
      for (int i = frontItem; i < rearSpace; i++) {
         out += elements[i] + " ";
      }
      return out;
   }
};




class PeekDeque : public StringDeque {
    int peekIndex;
 
    public: 
      
    
    PeekDeque(int guaranteeCapacity):StringDeque(guaranteeCapacity),peekIndex(guaranteeCapacity) {;} 
    
    
    virtual ~PeekDeque(){cout<<"Hi,there!"<<endl; delete(elements);}
	
   
    virtual string popRear(){
        if (isEmpty()){
            cout<<"Attempt to pop from empty PeekDeque"<<endl;
            return "";
        }else{
            peekIndex = rearSpace-1;
            return elements[--rearSpace];
        }
    }
        
    virtual string popFront(){
        if (isEmpty()){
            cout<<"Attmept to pop from empty PeekDeque"<<endl;
            return "";
        }else{
            peekIndex = frontItem+1;
            return elements[frontItem++];
        }
    }
    virtual void pushFront(string newItem) {
      elements[--frontItem]= newItem;
      peekIndex = frontItem;
    }
	
    virtual void pushRear(string newItem) {
      elements[rearSpace++] = newItem;
      peekIndex = rearSpace ;
    }
   
    virtual string peek(){
      return elements[peekIndex];
    }
    virtual string toString(){
       string out = "";
       for (int i = frontItem; i < rearSpace; i++){
           
            out += elements[i] + "";
       }
       return out;
    }
	 
    virtual void moveFrontward(){
	peekIndex--;
    }
    
    virtual void moveRearward(){
	peekIndex++;
    }
    virtual int printIndex(){
      
      return peekIndex;
    }
    virtual int printFrontItem(){
      return frontItem;
    }
    virtual int printRearSpace(){
      return rearSpace;
    } 
};    
    
    
    
    
           
       
int main (){
    
   PeekDeque* sd = new PeekDeque(100);
   sd->pushFront("oh");
   sd->pushFront("say");
   sd->pushFront("can");
   sd->pushFront("you");
   sd->pushFront("see");
   sd->pushRear("any");
   sd->pushRear("bad bugs");
   sd->pushRear("on");
   sd->pushRear("me?");
   
   
   if(sd->printIndex()>100){
      for(int i = sd->printIndex(); i>sd->printFrontItem()-1;i--){
    
         if (sd->peek()[0]== 's'||sd->peek()[0]=='S'){
            cout<<sd->peek()<<endl;
            sd->moveFrontward(); 
         }else{
            sd->moveFrontward();
            //cout<<""<<endl;
          }
      }
   }
   else if(sd->printIndex()<100){
       for(int i = sd->printIndex(); i<sd->printRearSpace()+1;i++){

           if (sd->peek()[0] == 's'||sd->peek()[0]=='S'){
              cout<<sd->peek()<<endl;
              sd->moveRearward();
           }else{
            sd->moveRearward();
            //cout<<""<<endl;
            }
       }

   }
   else{cout<<"The Deque is empty!"<<endl;}

   return 0;
}

