/** File "DequeTest.java", by KWR for CSE250, Spring 2013 and 2014.  For 
Assignment 2.  Translate this file into equivalent C++ code.
NOTE: This is different from a similarly-titled assignment in Fall 2010.
 */

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class StringDeque { //Front of deque is toward 0, but need not be 0.

   protected:
   vector<string>* elements;
   int frontItem;   //CLASS INV: indexes item with least index
   int rearSpace;   //CLASS INV: indexes space after item with greatest index
   int upperBound;  //For array[0..n-1] this is "n" not "n-1".

   //CLASS INV: frontSpace indicates first empty cell for pushFront
   //           rearSpace designates rear item (not space) for popRear---
   //           ---or if there is no such item, rearSpace == frontItem;


   public:
	StringDeque(int guaranteedCapacity): 
      	elements(new vector<string>(2*guaranteedCapacity)),frontItem(guaranteedCapacity),rearSpace(guaranteedCapacity),upperBound(2*guaranteedCapacity) {}

   /** C++ lingo: call the first two "empty" and "full".  Remember "const"!
    */

   virtual bool empty() const;
   virtual bool full() const;
   virtual int size() const;
   
   virtual string popRear();

   virtual string popFront();

   /** Directions include similarly testing for "full" in the C++ code.
    */
   virtual void pushFront(string newItem);
	
   virtual void pushRear(string newItem);

   virtual string toString();
};

