/** File "FlexArrayMGR.h", by MGR.  Updated for CSE250, Spring 2014
    Templated Data-structure file for Project 1.  Students need to add:
    (*) Iterator class---in labs from April 8 to 11
    (*) Methods T at(int j), iterator insert(iterator pos), 
        iterator erase(iterator pos) due on April 14
    (*) Project with expanded client due Mon. April 21.
 */

#ifndef _FLEXARRAY_H_
#define _FLEXARRAY_H

#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>
#include <exception>
#include <stdexcept>

using std::vector;
using std::endl;
using std::cerr;
using std::ostringstream;
using std::runtime_error;
using std::string;
using std::cout;
using std::ostream;
using std::ifstream;
using std::ofstream;
using std::stringstream;
using std::ios_base;
using std::allocator;


template <typename T>    //REQ: T has T() and T.str()
class FlexArray;

//template <typename T>
//class FlexArray::iterator;

template <typename T>
class ChunkNode {
   vector<T>* elements;
   ChunkNode* prev;          //optional, to make doubly-linked list

   ChunkNode<T>* next;       //typename is illegal here
   FlexArray<T>* myList;     //unnecessary? 
   size_t mySize;            //INV: # of elements actually stored
   friend class FlexArray<T>;
   friend class FlexArray<T>::iterator;   //begin lab with this line

 public:
   ChunkNode<T>(FlexArray<T>* myList, ChunkNode<T>* myPrev,
                                      ChunkNode<T>* myNext)
    : elements(new vector<T>()), prev(myPrev), next(myNext),
      myList(myList), mySize(0)
   { }
};

template <class T>
class FlexArray {
   ChunkNode<T>* firstNode;
   ChunkNode<T>* endNode;
   size_t nodeCap;
   size_t numNodes;
   //friend class ChunkNode<T>;   //IMHO not necessary

   //CLASS INV: endNode is a dummy node, used as target for iterations.
   //firstNode is a real node only when the FlexArray is nonempty
   //Empty is size() == 0, rather than endNode == firstNode.
   //Note: for empty FlexArray, rbegin() cannot assume endNode->prev is
   //non-NULL.  For empty FlexArray, both begin() and rbegin() should == end()
   //MOST IMPT: every node is nonempty---empty elements means de-allocate node.
   //elements is a compact array
   //If elements is empty, deallocate the node unless it iss the first node
   

 public:
      
   explicit FlexArray<T>(size_t nodeCap) 
    : firstNode(new ChunkNode<T>(this,NULL,NULL))
    , endNode(firstNode)
    , nodeCap(nodeCap)
    , numNodes(1)
   { }

   FlexArray<T>()
    : firstNode(new ChunkNode<T>(this,NULL,NULL))
    , endNode(firstNode)
    , nodeCap(40)
    , numNodes(1) 

   { }
   
   virtual ~FlexArray<T>(){
      while(firstNode->next!=NULL){
            ChunkNode<T>* tempNode=firstNode;
            firstNode=firstNode->next;
            delete tempNode;
         }
      delete(firstNode);
   }

   size_t size() const{
      ChunkNode<T>* node=firstNode;
      size_t size=node->mySize;
      while(node->next!=NULL){    
         size+=node->next->mySize;
         node=node->next;
      }
      return size;
   }
   
   bool empty() const{
      if(firstNode->elements->size()==0){
         return true;
      }
      else{return false;}  
   }

   T& at(size_t i){
      ChunkNode<T>* ptr=firstNode;
      bool foundRow=false;
      int spotCount=0;
      if(ptr->elements->size()-1<i){
         spotCount=ptr->elements->size();
      }
      while(foundRow==false && spotCount!=0){
         if(spotCount<=i){
            if(ptr->next==NULL && spotCount+ptr->elements->size()<i+1){
               cerr<<"Attempt to move past end position" << endl;
            }
            spotCount+=ptr->next->elements->size();
            ptr=ptr->next;
         }  
         else {
            spotCount-=ptr->elements->size();
            foundRow=true;
            ptr=ptr->prev;
         }
      }
      
      return ptr->elements->at(i-spotCount);
   }

   T& operator[](size_t i){
      at(i);
   }

/*   template<typename t>
   ostream& operator<< (ostream& out, const FlexArray<T>& ds) {
      out << ds.toString();
      return out;
   }
   
   template<typename t>
   ostream& operator<< (ostream& out, const FlexArray<T>*& dsp) {
      out << dsp->toString();
      return out;
   }*/
       
   class iterator {     //does not need "template <typename T>" since nested
                        //CANNOT see (non-static) fields of FlexArray directly.
                        //Hence having a "myList" field might be a good idea.
   const FlexArray<T>* myFlex;
   ChunkNode<T>* node;
   size_t localIndex;

   friend class FlexArray<T>;
   
   public:

   iterator(const FlexArray<T>* holder, ChunkNode<T>* node, size_t index): myFlex(holder), node(node), localIndex(index) {}

   T& operator*() const{
      if(node==NULL || node==myFlex->endNode){
         throw runtime_error("Attempt to de-reference end iterator");
      }
      else{
         return node->elements->at(localIndex);
      }
   }


   iterator& operator++(){
      if(node==myFlex->endNode){
         cerr<<"Attempt to move past end position" << endl;
      }  else if(node==NULL){
            node=myFlex->firstNode;
            localIndex=0;
      }  else {
            localIndex++;
            if(localIndex==node->mySize){
               node=node->next;
               localIndex=0;
            }
      }
      return *this;
   }

   iterator operator++(int ignored){
      iterator copy=*this;
      operator++();
      return copy;
   }       
  
   iterator& operator--(){
      if(node==myFlex->firstNode&&localIndex==0){
         cerr << "Attempt to move past begin position" << endl;
      }
      else if(node==NULL){
         node=myFlex->endNode;
         localIndex=0;
      }
      else if(localIndex=0){
            node=node->prev;
            localIndex=node->elements->size()-1;
      }
      else{
         localIndex--;
      }
      
      return *this;
   }   
   
   iterator operator=(const iterator& rhs){
      node=rhs.node;
      localIndex=rhs.localIndex;
      myFlex=rhs.myFlex;
      return *this; 
   }

   bool operator==(const iterator& rhs) const {
      return node==rhs.node && localIndex==rhs.localIndex && myFlex==rhs.myFlex;
   }

   bool operator!=(const iterator&rhs) const{
      return !(*this==rhs);
   }
   };
  
   iterator begin(){return iterator(this, this->firstNode, 0);}
   iterator end(){return iterator(this, this->endNode, 0);}
   iterator rbegin(){return iterator(this, this->endNode->prev, this->endNode->prev->mySize-1);}

   string toString(){
      string str="From start: ";
      for(int i=0; i<this->size(); i++){
         str+=this->at(i).str() + " ";
      }
      return str;
   }


   /** Returns iterator to *new* element, not the one inserted-before.
   New element has same co-ordinates as "beforeMe", *unless* node splits.
   Allows beforeMe == end(), which means appending item as new last elt.
   */
   iterator insert(iterator beforeMe, const T& item){
      typename vector<T>::iterator vit=beforeMe.node->elements->begin()+beforeMe.localIndex;
      //In NULL array
      if(empty()){
         firstNode=new ChunkNode<T>(this,NULL,end().node);
         firstNode->elements->push_back(item);
         firstNode->mySize++;
         beforeMe.node=firstNode; 
         beforeMe.localIndex=0;
         endNode->prev=firstNode;
      }

      //At end()
      else if(beforeMe==end()){
         beforeMe.node->prev->elements->push_back(item);
         beforeMe.node->prev->mySize++;
         --beforeMe;
      }

      //At beginning of vector exlcuding begin() and end()
      else if(beforeMe!=begin()&&beforeMe.localIndex==0){
         beforeMe.node->prev->elements->push_back(item);
         beforeMe.node->prev->mySize++;
      }
 
      else if(beforeMe==begin()){
         beforeMe.node->elements->insert(vit, item);
         beforeMe.node->mySize++;
      }
      else{beforeMe.node->elements->insert(vit, item);}
 
      //Split      
      if(beforeMe.node->elements->size()==beforeMe.myFlex->nodeCap){
         ChunkNode<T>* first=beforeMe.node;
         ChunkNode<T>* second=new ChunkNode<T>(this,first,first->next);
         first->next=second;
         int i=0;
         bool secondArrayIndex=false;
         while(first->elements->size()>second->elements->size()){
            if(beforeMe.localIndex==i){
               secondArrayIndex=true;   
            }
            second->elements->push_back(first->elements->at(0));
            first->elements->erase(first->elements->begin());
            i++;
         }
         if(secondArrayIndex==true){
            beforeMe.node=beforeMe.node->next;
         }
         else if(secondArrayIndex==false){
            beforeMe.localIndex=beforeMe.localIndex-second->elements->size();
         }
         return beforeMe;
      }
      else{return beforeMe;}
  }

   /** Splice-out element of "me", return valid iterator to the next element
   so that one can continue iterating. REQ: "me" *cannot* equal end().
   Does allow me == rbegin(), which means erasing the last element and
   returning end().
   */
   iterator erase(iterator me){
      typename vector<T>::iterator vit=me.node->elements->begin()+me.localIndex;
      if(me==end()||empty()){
         cerr<<"Attempt to erase null position" << endl;
      }
      else if(me==begin()&&me.myFlex->size()==1){
         iterator it=me;
         me++;
         it.node->elements->erase(vit);
         me.node->prev->mySize--;
         return me;  
      } 
      else if(me==rbegin()||me.node->mySize==me.localIndex){
         iterator it=me;
         me++;
         size_t newSize=it.node->mySize-1;
         it.node->elements->erase(vit);
         me.node->prev->mySize=newSize;
         return me;
      }
      else{
         iterator it=me;
         me++;
         me.node->elements->erase(vit);
         me.node->mySize--;
         return me;
      }
   }
};

#endif

