//Mitchell Rathbun FlexClientMGR.cpp
#include <iostream>
#include <string>
#include <fstream>
#include <sstream>

#include "FlexArrayMGR.h"
#include "StringWrapKWR.h"
#include "StringWrapKWR.cpp"

//This method will output true if the edit distance between the two string 
//passed as arguments is 1. Otherwise it will return false.
bool ed1(const string& xx, const string& yy){
   string x = xx;
   string y = yy;

   /*Initializes 3 count variables to be used when comparing strings that differ   by one in length.*/
   int count=0;
   int count1=0;
   int count2=0;

   //Makes sure x is larger string
   if(y.length()>x.length()){
      string temp=x;
      x=y;
      y=temp;
   }

   //Compares strings of equal length
   /*For this block, count indicates the number 
     of differences by position between the strings
     and must be 1 for the block to return true*/
   if(x.length()==y.length()){ 
      for(int i=0; i<x.length(); i++){
         if(x[i]!=y[i]){
            count++;
         }
      }
      if(count==1){
         return true;
      }
      else{
         return false;
      }
   }

   //Compares strings differing by 1 in length
   /*count indicates the amount of times relatively 
     similar positions in the strings are equal and 
     must be equal to y.length() for the block to be true*/
   /*count1 serves as a way to indicate the first time
     count makes a change*/
   /*count2 indicates whether count has changed atleast
     once or not at all. This will always be a 1 or 0*/
   else if(x.length()-1==y.length()){
      
      int j=0;

      for(int i=0; i<x.length(); i++){
         if((i>0&&count1==count)||count2==1){
            j=i-1;
            count2=1; 
         }
         else if(count1!=count){
            j=i;
            count1=count;
         }
         if(x[i]==y[j]){
            count++;   
         }   
      }  
      if(count==y.length()){
         return true;
      }
      else {return false;}
   }

   //Returns false for all strings differing in length by more than 1
   else{return false;}

   }
     
bool transpose(const string& x, const string& y){
   int count=0;
   if(x.length()!=y.length()){
      return false;
   }
   for(int i=0; i<x.length(); i++){
      if(x[i]!=y[i]){
         if(x[i]==y[i+1]&&x[i+1]==y[i]){
            count++;
            i++;
         }
         else{return false;}
      }
   }
   return count==1;
}

bool dd1(const string& x, const string& y) {
   return ed1(x,y) || transpose(x,y);
}

/*If the chain can't be inserted at the beginning or end of the string, this method allows for it to be inserted into any place in the middle of the string*/
void testNewWordInsertMiddle(const StringWrap& sw, FlexArray<FlexArray<StringWrap>* >* chains){
   bool partOfChain=false;
   string check;

   if (sw.size() <= 2){ //word too short, so start a new deque
      FlexArray<StringWrap>* fa1=new FlexArray<StringWrap>(100);
      fa1->insert(fa1->end(),sw);
      chains->insert(chains->end(),fa1);
      return;
   }
   for(int i=0; i<chains->size(); i++){
      if(dd1(sw.str(), chains->at(i)->at(chains->at(i)->size()-1).str())){
         chains->at(i)->insert(chains->at(i)->end(),sw);
         partOfChain=true;
      }
      else if(dd1(sw.str(),chains->at(i)->at(0).str())){
         chains->at(i)->insert(chains->at(i)->begin(), sw);
         partOfChain=true;
      }
      else{
         for(FlexArray<StringWrap>::iterator j=chains->at(i)->begin(); j!=chains->at(i)->end(); ++j){
            if(j==chains->at(i)->begin()){
               check="";
            }
            if(dd1((*j).str(),sw.str())&&dd1(check,sw.str())){
               chains->at(i)->insert(j,sw);
               partOfChain=false;
               j=chains->at(i)->rbegin();
            }
            check=(*j).str();
         }
      }
   }  
   if(partOfChain==false){//Not part of any current chain so start new deque
      FlexArray<StringWrap>* fa2=new FlexArray<StringWrap>(100);
      fa2->insert(fa2->end(),sw);
      chains->insert(chains->end(),fa2);
   }
}

/*Bare minimum testing method mirroring the requirements of assignment 5*/
void testNewWord(const StringWrap& sw, FlexArray<FlexArray<StringWrap>* >* chains){
   bool partOfChain=false;

   if (sw.size() <= 2){ //word too short, so start a new deque
      FlexArray<StringWrap>* fa1=new FlexArray<StringWrap>(100);
      fa1->insert(fa1->end(),sw);
      chains->insert(chains->end(),fa1);
      return;
   }
   for(int i=0; i<chains->size(); i++){
      if(dd1(sw.str(), chains->at(i)->at(chains->at(i)->size()-1).str())){
         chains->at(i)->insert(chains->at(i)->end(),sw);
         partOfChain=true;   
      }
      else if(dd1(sw.str(),chains->at(i)->at(0).str())){
         chains->at(i)->insert(chains->at(i)->begin(), sw);
         partOfChain=true;
      }
   }
   if(partOfChain==false){//Not part of any current chain so start new deque
      FlexArray<StringWrap>* fa2=new FlexArray<StringWrap>(100);
      fa2->insert(fa2->end(),sw);
      chains->insert(chains->end(),fa2); 
   }
}


/** For each chain, see if we can attach sw's word at front or back. Add the 
requirement that no word can be repeated in a chain.
 */
void testNewWordNoRepeats(const StringWrap& sw, FlexArray<FlexArray<StringWrap>* >* chains){
   bool partOfChain=true;

   if (sw.size() <= 2){ //word too short, so start a new deque
      FlexArray<StringWrap>* fa1=new FlexArray<StringWrap>(100);
      fa1->insert(fa1->end(),sw);
      chains->insert(chains->end(),fa1);
      return;
   }

   for(int i=0; i<chains->size(); i++){
      
      if(dd1(sw.str(), chains->at(i)->at(chains->at(i)->size()-1).str())){
         for(FlexArray<StringWrap>::iterator j=chains->at(i)->begin(); j!=chains->at(i)->end(); ++j){
            if((*j).str()==sw.str()){
               partOfChain=false;
            }
         }
         if(partOfChain==true){
            chains->at(i)->insert(chains->at(i)->end(),sw);
            partOfChain=false;
         }
      }

      else if(dd1(sw.str(),chains->at(i)->at(0).str())){
         for(FlexArray<StringWrap>::iterator j=chains->at(i)->begin(); j!=chains->at(i)->end(); ++j){
            if((*j).str()==sw.str()){
               partOfChain=false;
            }
         }
         if(partOfChain==true){
            chains->at(i)->insert(chains->at(i)->begin(),sw);
            partOfChain=false;
         } 
      }
   }

   if(partOfChain==true){//Not part of any current chain so start new deque
      FlexArray<StringWrap>* fa2=new FlexArray<StringWrap>(100);
      fa2->insert(fa2->end(),sw);
      chains->insert(chains->end(),fa2);
   }
}

/** Combines the functionality of testNewWordNoRepeats and TestNewWordInsertMiddle
 */
void testNewWordOptimum(const StringWrap& sw, FlexArray<FlexArray<StringWrap>* >* chains){
   bool partOfChain=true;
   string check;

   if (sw.size() <= 2){ //word too short, so start a new deque
      FlexArray<StringWrap>* fa1=new FlexArray<StringWrap>(100);
      fa1->insert(fa1->end(),sw);
      chains->insert(chains->end(),fa1);
      return;
   }

   for(int i=0; i<chains->size(); i++){

      if(dd1(sw.str(), chains->at(i)->at(chains->at(i)->size()-1).str())){
         for(FlexArray<StringWrap>::iterator j=chains->at(i)->begin(); j!=chains->at(i)->end(); ++j){
            if((*j).str()==sw.str()){
               partOfChain=false;
            }
         }
         if(partOfChain==true){
            chains->at(i)->insert(chains->at(i)->end(),sw);
            partOfChain=false;
         }
      }

      else if(dd1(sw.str(),chains->at(i)->at(0).str())){
         for(FlexArray<StringWrap>::iterator j=chains->at(i)->begin(); j!=chains->at(i)->end(); ++j){
            if((*j).str()==sw.str()){
               partOfChain=false;
            }
         }
         if(partOfChain==true){
            chains->at(i)->insert(chains->at(i)->begin(),sw);
            partOfChain=false;
         }
      }

      else{
         for(FlexArray<StringWrap>::iterator j=chains->at(i)->begin(); j!=chains->at(i)->end(); ++j){
            if((*j).str()==sw.str()){
               partOfChain=false;
            }
         }
         if(partOfChain==true){
            for(FlexArray<StringWrap>::iterator j=chains->at(i)->begin(); j!=chains->at(i)->end(); ++j){
               if(j==chains->at(i)->begin()){
                  check="";
               }
               if(dd1((*j).str(),sw.str())&&dd1(check,sw.str())){
                  chains->at(i)->insert(j,sw);
                  partOfChain=false;
                  j=chains->at(i)->rbegin();
               }
               check=(*j).str();
            }
         }
      }
   }

   if(partOfChain==true){//Not part of any current chain so start new deque
      FlexArray<StringWrap>* fa2=new FlexArray<StringWrap>(100);
      fa2->insert(fa2->end(),sw);
      chains->insert(chains->end(),fa2);
   }
}


//Prints out the longest chain
void findLongestChain(FlexArray<FlexArray<StringWrap>* >* chains){
   int longest=0;
   int length=0;

   for(int i=0; i<chains->size(); i++){
      if(chains->at(i)->size()>length){
         length=chains->at(i)->size();
         longest=i;
      }
   }
  
   cout << "The longest chain is: " << chains->at(longest)->toString()<< endl;
}



//Prints out the chain with the longest word
void findLongestWord(FlexArray<FlexArray<StringWrap>* >* chains){

   int longestCount=0;
   int wordLength=0;

   for(int i=0; i<chains->size(); i++){
      for(FlexArray<StringWrap>::iterator j=chains->at(i)->begin(); j!=chains->at(i)->end(); ++j){
         if((*j).size()>wordLength&&chains->at(i)->size()>1){
            wordLength=(*j).size();
            longestCount=i;
         }
      }
   }

   cout << "The chain with the longest word is: ";
   cout << chains->at(longestCount)->toString() << endl;
}

//Prints out the chain with the best growth rate
void findBestGrowth(FlexArray<FlexArray<StringWrap>* >* chains){
   
   int difference=0;
   int shortestCount=100;
   int longestCount=0;
   int chainSpot=0;

   for(int i=0; i<chains->size(); i++){
      for(FlexArray<StringWrap>::iterator j=chains->at(i)->begin(); j!=chains->at(i)->end(); ++j){   
         if((*j).size()>longestCount&&chains->at(i)->size()>1){
            longestCount=(*j).size();
         }
         if((*j).size()<shortestCount&&chains->at(i)->size()>1){
            shortestCount=(*j).size();
         }
      }

      if((longestCount-shortestCount)>difference&&chains->at(i)->size()>1){
         difference=longestCount-shortestCount;
         chainSpot=i;
         }
      shortestCount=100;
      longestCount=0;  
   }
   cout << "The chain with the best growth rate is: ";
   cout << chains->at(chainSpot)->toString() << endl;
}

//Prints out the chain with the most transpositions
void findMostTranspositions(FlexArray<FlexArray<StringWrap>* >* chains){
   int transposeCount=0;
   int transposeMax=0;
   int chainSpot=0;
   string check;

   for(int i=0; i<chains->size(); i++){
      if(chains->at(i)->size()>1){
      for(FlexArray<StringWrap>::iterator j=chains->at(i)->begin(); j!=chains->at(i)->end(); ++j){
         if(j==chains->at(i)->begin()){
            check="";
         }
         if(transpose((*j).str(),check)){ 
            transposeCount++;
         }
         check=(*j).str();
      }
      if(transposeCount>transposeMax){
         transposeMax=transposeCount;
         chainSpot=i;
      }
      transposeCount=0;   
   }
   }

   if(transposeMax==0){
      cout << "There are no chains with transpositions" << endl;
   }
   else{
   cout << "The chain with the most transpositions, with " << transposeMax;
   cout << ", is: ";
   cout << chains->at(chainSpot)->toString() << endl;
   }
}

int main(int argc, char** argv) {
   FlexArray<FlexArray<StringWrap>* >* chains= new FlexArray<FlexArray<StringWrap>* >();
   string entry;
   int limit=0;
   

   //Reads whole file into chains 
   if(argc == 2){
      string inFileName=argv[1];
      ifstream* InFile=new ifstream(inFileName.c_str(), ios_base::in);
      while(*InFile >> entry){
      StringWrap sw(entry);
      sw.trimNonAlphaNum();
      sw.makeLower();
      testNewWordOptimum(sw,chains);
   }
   InFile->close();
   }

   //Reads specified number of words into chains
   if(argc > 2){
      string inFileName=argv[1];
      int count=0;
      int limit=0;
      stringstream(argv[2])>>limit;
      ifstream* InFile=new ifstream(inFileName.c_str(), ios_base::in);
      while((*InFile >> entry)&&(count<limit)){
         StringWrap sw(entry);
         sw.trimNonAlphaNum();
         sw.makeLower();
         testNewWordOptimum(sw,chains);
         count++;
      }
      InFile->close();
   }

   findLongestChain(chains);
   findLongestWord(chains);
   findBestGrowth(chains);
   findMostTranspositions(chains);
}

/*
Questions:

1. Yes, the iterators made it significantly easier to code the longest-word and best-growth methods. For both of the tasks, I needed to look at every word that was added to the FlexArray and compare it to a given value. For the longest-word task, I created an int to represent the longest StringWrap and also one to indicate which chain this occurred in. I did the same for the best-growth task, except I created ints for the longest word, the shortest word, and the difference in size between these two words for every chain. I also had an int to represent the greatest difference and the chain in which this difference occurs. To accomplish the tasks, I needed to "iterate" through all of the chains. With the peekIndex, I first needed to set it to the front of the PeekDeque for every new chain. Then I used a for loop to go through the chains. However, I had to increment the peekIndex separately. With the iterators in the FlexArray, I didn't need to do this. The iterator gave me direct access to each word, and I didn't need to increment it separately in the loop body since it was the bounds for the for loop. In addition, I didn't need to reset it for every new chain because the loop already does that. Overall, the FlexArray iterator made it easier to code the longest-word and best-growth tasks than the peekIndex.

2. The change does not seem to make that much of a difference. The run times are a little slower when reading in a lot of words, but again, the difference is not substantial.

Note: While not required, I used testNewWordOptimum in the final code because it gives the best chains. The required methods all work as well.
*/  










