//Mitchell Rathbun PeekClientMGR.cpp
#include <iostream>
#include <string>
#include <fstream>

#include "PeekDequeTemplateMGR.h"

using namespace std;

//This method will output true if the edit distance between the two string 
//passed as arguments is 1. Otherwise it will return false.
bool ed1(string& x, string& y){
   
   /*Initializes 3 count variables to be used when comparing strings that differ   by one in length.*/
   int count=0;
   int count1=0;
   int count2=0;

   //Makes sure x is larger string
   if(y.length()>x.length()){
      string temp=x;
      x=y;
      y=temp;
   }

   //Compares strings of equal length
   /*For this block, count indicates the number 
     of differences by position between the strings
     and must be 1 for the block to return true*/
   if(x.length()==y.length()){ 
      for(int i=0; i<x.length(); i++){
         if(x[i]!=y[i]){
            count++;
         }
      }
      if(count==1){
         return true;
      }
      else{
         return false;
      }
   }

   //Compares strings differing by 1 in length
   /*count indicates the amount of times relatively 
     similar positions in the strings are equal and 
     must be equal to y.length() for the block to be true*/
   /*count1 serves as a way to indicate the first time
     count makes a change*/
   /*count2 indicates whether count has changed atleast
     once or not at all. This will always be a 1 or 0*/
   else if(x.length()-1==y.length()){
      
      int j=0;

      for(int i=0; i<x.length(); i++){
         if((i>0&&count1==count)||count2==1){
            j=i-1;
            count2=1; 
         }
         else if(count1!=count){
            j=i;
            count1=count;
         }
         if(x[i]==y[j]){
            count++;   
         }   
      }  
      if(count==y.length()){
         return true;
      }
      else {return false;}
   }

   //Returns false for all strings differing in length by more than 1
   else{return false;}

   }

/* If the PeekDeque contains a legal chain, this method will return true.
Otherwise it will return false. */
bool legalChain(PeekDeque<string>* pd){
   pd->setPeekToFront();
   string str1;
   string str2;
   if(pd->size()<2){
      return true;
   }
   for(int i=pd->front();i<pd->rear()-1;i++){
      str1=pd->peek();
      pd->moveRearward();
      str2=pd->peek(); 
      if(!ed1(str1,str2)){
         return false;
      }
   }       
   return true;
}

int main() {
   PeekDeque<string>* pd = new PeekDeque<string>(100);
   string entry;
   string inFileName="words.txt";
   ifstream* InFile=new ifstream(inFileName.c_str(), ios_base::in);
   while(getline(*InFile, entry)){
      pd->pushRear(entry);
   }
   cout << legalChain(pd) << endl;
}

/*Having 2 index-peekers at once would be ideal. This would allow for much 
faster recursion of the PeekDeque and could be used to seperate the items that
were pushed onto the rear and those that were pushed onto the front. To 
implement code with two index-peekers, one would need to initialize one to the
frontItem and one to rearSpace. They would also have to include two setIndex
functions and two getIndex functions. If one were to separate the front and 
backhalf, they would have to set a limit for both of the peekIndexes at the size
of the PeekDeque, or half the size of the vector. If peekIndex were a public
object, then it would it would be very useful for derived classes. However 
that might offer too much functionality in the derived class, and wouldn't 
really aid the functionality in the initial PeekDeque class.*/
