/** "diclookupQL.cpp" by Qing Liu, CSE250 Spring 2013 
*/

#include "StackPairQL.h"
#include <string>
#include <iostream>
#include <stdlib.h>
#include <map>

using namespace std;


Phone_Directory::Phone_Directory():
  the_directory() {}

string Phone_Directory::add_or_change_entry(const string& name,
                                            const string& number)
{
  map<string,string>::iterator it;
  it = the_directory.find(name);
  string old_number = "";
   
  if (it!=the_directory.end()) {
    old_number = it->second;
    it -> second = number;
  } else {
    the_directory.insert(pair<string,string>(name,number));
  }
  
  return old_number;
}

string Phone_Directory::lookup_entry(const string& name) const
{
  map<string,string>::const_iterator it = the_directory.find(name);
 
  if(it!=the_directory.end()) {
    return it -> second;
  } else {
    return "";
  } 
}

string remove_entry(const string& name)
{
  map<string,string>::iterator it;
  it = the_directory.find(name);
  string old_number = ""; 
  
  if (it!=the_directory.end()) {
      old_number = it -> second;
      the_directory.erase(it);     
    }
 
  return old_number;
}



void Phone_Directory::add(const string& name, 
                          const string& number)
{
  the_directory.insert(pair<string,string>(name,number));
}






/** Report question:

Three methods themselves run in approximently O(nlogn) time because condition 
only require 1 for loop and a binary search embeded inside; which creates 
maximun runtime of O(n)*O(logn) euqals O(nlogn).

Q(a): For O(1) runtime the efficiency is up, however when looking for a word in
array based structures O(1) is not likely the case, runtime will be at least 
O(n)

Q(b): If we were to make wordTurnAll a function into O(n) runtime, then there 
couldn't be any binary serach or other advanced searching pattern. Also there 
can't be any loop variant involed, so it is very unlikely this will be the case.

*/

