#ifndef VALLI_H_
#define VALLI_H_

#include "DList.h"
#include <vector>
using std::vector;

template <typename I>
class valli
{
public:
	class iterator
	{
		typename DList<I>::iterator list_iter;

		iterator(const typename DList<I>::iterator& l_iter)
			:list_iter(l_iter){} //?

		friend class valli<I>;

	public:
		iterator(){}

		iterator(const iterator& other)
			:list_iter(other.list_iter){} //?

		iterator& operator=(const iterator& rhs)
		{
			list_iter = rhs.list_iter;
			return *this;
		}

		I& operator*() const
		{
			return *list_iter;
		}

		iterator& operator++()
		{
			++list_iter;
			return *this;
		}

		iterator operator++(int)
		{
			iterator oldMe = *this;
			list_iter++;
			return oldMe;
		}

		bool operator==(const iterator& rhs) const
		{
			return list_iter == rhs.list_iter;
		}

		bool operator!=(const iterator& rhs) const
		{
			return list_iter != rhs.list_iter;
		}
	};

private:
	DList<I> list;
	vector<iterator> vec;
	size_t n, r;

public:
	explicit valli(size_t ratio = 20)
		:list(DList<I>())
		,vec(vector<iterator>())
		,n(0), r(ratio){}

	~valli(){}

	iterator begin() const
	{
		return iterator(list.begin());
	}

	iterator end() const
	{
		return iterator(list.end());
	}

	iterator find(const I& item) const //Find vector before(bin), go into list and find(lin)
	{
		size_t left = 0;
		size_t right = vec.size();
		while (right > left + 1) //binsearch through vector
		{
			size_t mid = (right+left)/2;
			if (item < *vec.at(mid))
			{
				right = mid;
				break;
			}
			else
			{
				left = mid;
			}
		}
		iterator iter = vec[left];
		for (iter; iter != vec[right-1]; iter++) //linsearch through list
		{
			if (*iter == item)
			{
				return iter;
			}
			if (*iter > item)
			{
			return end();
			}
		}
		return end();
	}

	iterator insert(const I& item)
	{
		size_t left = 0;
		size_t right = vec.size();
		while (right > left + 1) //binsearch through vector
		{
			size_t mid = (right+left)/2;
			if (item < *vec.at(mid))
			{
				right = mid;
				break;
			}
			else
			{
				left = mid;
			}
		}
		iterator iter = vec[left];
		for (iter; iter != vec[right-1]; iter++) //linsearch through list
		{
			if (*iter >= item)
			{
				break;
			}
		}
		iterator result(list.insert(iter.list_iter, item));
		if (++n > 2 * r * vec.size())
		{
			refresh();
		}
		return result;
	}
	
	void erase(const I& item)
	{
		size_t left = 0;
		size_t right = vec.size();
		while (right > left + 1) //binsearch through vector
		{
			size_t mid = (right+left)/2;
			if (item < *vec.at(mid))
			{
				right = mid;
				break;
			}
			else
			{
				left = mid;
			}
		}
		iterator iter = vec[left];
		for (iter; iter !=vec [right-1]; iter++) //linsearch through list
		{
			if (*iter >= item)
			{
				break;
			}
		}
		//list.erase(iter); //DList erase? 
		if (iter.list_iter.curr->prev == NULL) //Remove from beginning
		{
		   //firstNode->iter->next();
			iter.list_iter.curr->next->prev = NULL; //resets first pointer?
		} 
		else if(iter.list_iter.curr->next == NULL) //Remove from end
		{
		   iter.list_iter.curr->prev->next = NULL; //reset end pointer
		} 
		else //Remove from middle
		{ 
		   iter.list_iter.curr->prev->next = iter.list_iter.curr->next; //reset previous node to skip to next node
		   iter.list_iter.curr->next->prev = iter.list_iter.curr->prev; //reset next node to skip to previous node
		}
		delete iter.list_iter.curr;  //Delete node
	}

	size_t size() const
	{
		return n;
	}

	bool empty() const
	{
		return size() == 0;
	}

	string str() const
	{
		return list.toString();
	}

	/*
	void erase (iterator itr) //Code from Recitation
	{
		Cell* delendum = itr.curr;
		size_t i = binsearch(*itr);
		size_t j = i-1;
		bool refreshFlag = false;
		while (j<=0 && j!<(mileposts->at(j)->data, *itr))
		{
			if (mileposts->(j)==delendum)
			{
				refreshFlag = mileposts->at(j-1) == delendum->next;
				mileposts->at(j) = delendum->next;
				break;
			}
		}
		delendum->prev->next = delendum->next;
		delendum->next->prev = delendum->prev;
		delete(delendum);
		numItems--;
		if (refreshFlag)
			refresh();
	}
	**/
	void refresh(size_t newRatio) //CHANGE
	{
		r = newRatio;
		vec.clear();
		size_t count = r;
		for (iterator iter = begin(); iter != end(); iter++, count++)
			if (count == r)
			{
				count = 0;
				vec.insert(vec.end(), iter);
			}
	}

	void refresh()
	{
		refresh(r);
	}
};

#endif
