#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <vector>
#include "ValliRAB.h"
using namespace std;

string wordreverse(string word)
{
	string reversed = word;
	int length = reversed.length();
	for (int i = 0; i < length/2; i++)
		swap(reversed[i], reversed[length - 1 - i]);
	return reversed;
};

int main(int argC, char* argV[])
{
	if (argC > 1)
	{
		ifstream fin(argV[1]);
		if (fin.is_open())
		{
			vector<string> originalWords;
			valli<string> reversedWords;
			while (!fin.eof())
			{
				string word;
				fin >> word;
				if (word.length() > 3)
				{
					originalWords.push_back(word);
					string reversed = wordreverse(word);
					reversedWords.insert(reversed);
				}
			}
			fin.close();

			ofstream fout("reversedwords.txt");
			for (valli<string>::iterator i = reversedWords.begin(); i != reversedWords.end(); i++)
				fout << *i << endl;
			fout.close();
		}
	}
	return 0;
}
