//Rachel Broardt #36842158 CSE250 Spring2013 Assignment#6

#include<iostream>
#include<cstdlib>
#include<vector>
#include<fstream>
#include<algorithm>
#include"StackPairRAB.h"
using namespace std;

string wordTurn(const string& word)
{
	int length = word.length();
	FrontStack<char> frontStack(length);
	BackStack<char> backStack(length);
	if (length%2==1)
		frontStack.pushRear1(word[length/2]);
	length = length-1;
	for (int i=0; i<length; i++)
	{
		frontStack.pushRear1(word[i]);
		backStack.pushRear2(word[length]);
		length--;
	}
	string newword = "";
	while (!frontStack.isEmpty1())
		newword+=frontStack.popRear1();
	while (!backStack.isEmpty2())
		frontStack.pushRear1(backStack.popRear2());
	while (!frontStack.isEmpty1())
		newword+=frontStack.popRear1();
	return newword;
};

bool binsearch(const vector<string>& words, const string& newword)
{
	return binary_search (words.begin(), words.end(), newword);
};

//REQ text file must have no trailing spaces, punctuation, or capital letters.
int main(int argc, char* argv[])
{
	if (argc==2)
	{
	string filename(argv[1]);
	ifstream fin(filename.c_str());
	string word;
	string newword;
	vector<string> words;
	int vectorLength;
	if (fin.is_open())
	{
		ofstream fout("pairs.txt");
		while (!fin.eof())
		{
			fin>>word;
			words.push_back(word);
		}
		vectorLength = words.size();
		for (int i=0; i<vectorLength-1; i++) //LOOP INV
		{
			newword = wordTurn(words[i]);
			if (binsearch(words,newword)==true)
			{
				fout<<words[i]<<"     "<<newword<<endl;
			}
		}
		fin.close();
		fout.close();
	}
	else
		cerr<<"File Invalid: Needs one valid text file to run."<<endl;
	}
	else
		cerr<<"Please input ONE text file."<<endl;
return (0);
}

/* The three methods promise to run in O(n log n) time because that is the 
largest amount of time needed for the searches and sorts to take place. 
For the first one, wordTurn runs in O(1) and binsearch runs in O(n log n), 
so therefore the method as a whole will run in O(n log n) time. 
The same reasons with the other two methods, respectively. 
Parts a and b, having a run time of O(1) and O(n) would be an improvement 
upon O(n log n), so I would prefer that, assuming the code was stronger 
and faster than mine currently is. **/

