/**
 Raymond Chen   DequeTestRC.cpp   CSE250
Translation of DequeTest.java to DequeTest.cpp
 */


#include <iostream>
#include <vector>
#include <string>
using namespace std;
class StringDeque {
    vector<string>* elements;
    int frontItem;
    int rearSpace;
    int upperBound;
    
public: StringDeque(int guaranteedCapactity){
    elements = new vector<string>(2*guaranteedCapactity);
    frontItem = guaranteedCapactity;
    rearSpace = guaranteedCapactity;
    upperBound = 2*guaranteedCapactity;
}
    
 bool isEmpty() {return frontItem == rearSpace;}
 bool isFull() {return rearSpace == upperBound || frontItem == 0;}
 int size() {return rearSpace - frontItem;}
    
 string popRear(){
        if(isEmpty()) {
            cout << "Later we'll define and throw an EmptyQException" << endl;
            return "";
        }else{
            return elements->at(--rearSpace);
        }
    }
 string popFront(){
        if(isEmpty()){
            cout << "Later we'll define and throw an EmptyQException" << endl;
            return "";
        }else{
            return elements->at(frontItem++);
        }
    }
 void pushFront(string newItem){
        elements->at(--frontItem) = newItem;
    }
 void pushRear(string newItem){
        elements->at(rearSpace++) = newItem;
}
 string toString(){
        string out = "";
        for(int i = frontItem; i<rearSpace; i++){
            out += elements->at(i) + " ";
        }
        return out;
    }
};
int main(int argc, char** argv){
    StringDeque* sd = new StringDeque(100);
    sd->pushFront("oh");
    sd->pushFront("say");
    sd->pushFront("can");
    sd->pushFront("you");
    sd->pushFront("see");
    sd->pushRear("any");
    sd->pushRear("bad bugs");
    sd->pushRear("on");
    sd->pushRear("me?");
    cout << sd->toString() << endl;
    string pop2 = sd->popRear() + " " + sd->popRear();
    cout << pop2 << ", did this print in the right order?" << endl;
    sd->pushFront("I");
    cout << "Final deque: " << sd->toString() << endl;
    return 0;
}



/**
 Both C++ and Java produces the same output because both reads the statement 
pop2 from left to right.
*/
