/*   StackPair.h by Raymond Chen     CSE250
Added destructor for the StackPair class.
*/


#include <vector>
#include <cstdlib>
#include <iostream>
#include <cmath>
using namespace std;

template<class T>
class StackPair {
    vector<T>* myArray;
    int bottomA;
    int topB;
    int bottomB;
    
public:
    StackPair(int n);
    bool full();
    bool emptyA();
    bool emptyB();
    int size();
    void pushA(T itemA);
    void pushB(T itemB);
    T popA();
    T popB();
    ~StackPair();
};

template<class T>
StackPair<T>::StackPair(int n) {
    myArray = new vector<T>(n);
    bottomA = 0;
    bottomB = n;
    topB = bottomB;
}

template<class T>
bool StackPair<T>::full() {return topB == bottomA;}
template<class T>
bool StackPair<T>::emptyA() {return bottomA == 0;}
template<class T>
bool StackPair<T>::emptyB() {return topB == bottomB;}
template<class T>
int StackPair<T>::size() {return bottomA + (bottomB - topB);}

template<class T>
void StackPair<T>::pushA(T itemA){
    if(full()) {
        cout << "FULL!" << endl;
    }else{
        myArray->at(bottomA++) = itemA;
    }
}

template<class T>
void StackPair<T>::pushB(T itemB){
    if(full()) {
        cout << "FULL!" << endl;
    }else{
        myArray->at(--topB) = itemB;
    }
}

template<class T>
T StackPair<T>::popA(){
    if(emptyA()){
        cout << "EMPTY!" << endl;
        return 0;
    }else{
        T itemA = myArray->at(--bottomA);
        (*myArray)[bottomA]='\0';
        return itemA;
    }
}

template<class T>
T StackPair<T>::popB(){
    if(emptyB()){
        cout << "EMPTY!" << endl;
        return 0;
    }else{
        T itemB = myArray->at(topB);
        (*myArray)[topB]='\0';
        topB++;
        return itemB;
    }
}

template<class T>
StackPair<T>::~StackPair() {
    delete myArray;
}
