#ifndef _FLEXARRAY_H_
#define _FLEXARRAY_H

#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>
#include <exception>
#include <stdexcept>

using std::vector;
using std::endl;
using std::cerr;
using std::ostringstream;
using std::runtime_error;


template <typename T>    //REQ: T has T() and T.str()
class FlexArray;

//template <typename T>
//class FlexArray::iterator;

template <typename T>

  class ChunkNode {
   vector<T>* elements;
   ChunkNode* prev;          //optional, to make doubly-linked list

   ChunkNode<T>* next;       //typename is illegal here
   //FlexArray<T>* myList;   //unnecessary?
   size_t mySize;            //INV: # of elements actually stored
   friend class FlexArray<T>;
   friend class FlexArray<T>::iterator;   //begin lab with this line

 public:
   ChunkNode<T>(FlexArray<T>* myList, ChunkNode<T>* myPrev,
                                      ChunkNode<T>* myNext)
    : elements(new vector<T>()), prev(myPrev), next(myNext),
      myList(myList), mySize(0)
   { }
};
template <class T>
class FlexArray {
   ChunkNode<T>* firstNode;
   ChunkNode<T>* endNode;
   size_t nodeCap;
   size_t numNodes;
   //friend class ChunkNode<T>;   //IMHO not necessary

   //CLASS INV: endNode is a dummy node, used as target for iterations.
   //firstNode is a real node only when the FlexArray is nonempty (Optional change)
   //Empty is size() == 0, rather than endNode == firstNode.
   //Note: for empty FlexArray, rbegin() cannot assume endNode->prev is
   //non-NULL.  For empty FlexArray, both begin() and rbegin() should == end()
   //MOST IMPT: every non-dummy node is nonempty---empty elements means de-allocate node.

 public:

   explicit FlexArray<T>(size_t nodeCap)
    : firstNode(new ChunkNode<T>(this,NULL,NULL))
    , endNode(firstNode)
    , nodeCap(nodeCap)
    , numNodes(1)
   { }


 FlexArray<T>()
    : firstNode(new ChunkNode<T>(this,NULL,NULL))
    , endNode(firstNode)
    , nodeCap(40)
    , numNodes(1)
   { }

   class iterator {
        
      FlexArray* myList;
      ChunkNode* node;
      size_t localIndex;
      
	iterator(FlexArray* myList, ChunkNode* node, size_t li)
        :myList(myList), node(node), myIndex(li){}

      friend class FlexArra<T>;
     
	 T& Operator* (){
        if(node == NULL || node == myList->endNode)
           throw runtime-error("node is null or at the end of array");

         return node->elements->at(myIndex);
      }

      iterator operator ++(){
         myIndex ++;

         if(myIndex == node->element->size()){
            node = node->next;
            myIndex = 0;
         }

         return *this;
      }


      iterator operator ++(int ignored){
        iterator copy = *this;
        operator ++(); // ++this
        return copy;
      }

      bool operator == (const iterator & rhs) const{

        return (myIndex == rhs->myIndex && node == rhs->node && myList == rhs->myList);
      }


      bool operator != (const iterator && rhs) const{


return (myIndex != rhs->myIndex || node != rhs->node || myList == rhs->myList);
         
 //////* returns !(this==rhs);//*
      }

      iterator starting(){
        return iterator(this, firstNode, 0);
      }

      iterator finishing(){
        return iterator(this, endNode, 0);
      }

      iterator start2(){
         return iterator(this, endNode->prev, endNode->prev->elements->size()-1);
      }
   };

T at(int j){

   int prevAdd = 0;
   Node<T>* current = firstNode;
   while (j >= prevAdd + current->elements->size()) {
      prevAdd += current->elements->size();
      current = current->next;
   }
   int myIndex = j - prevAdd;
   return std::pair<int,Node<T>*>(localIndex,current)   }

iterator insert(iterator pos, const T& newItem){
 
  int prevAdd = 0;
	 Node<T>* current = firstNode;
   while (pos > prevAdd + current->elements->size()) {
      prevSum += current->elements->size();
      current = current->next;
   }
   int myIndex = pos - prevAdd;
   current->elements<myIndex>->push_back(newItem);
   return pos;}


iterator erase(interator pos){

   int prevAdd = 0;
   Node<T>* current = firstNode;
   while (pos > prevAdd + current->elements->size()) {
      prevAdd += current->elements->size();
      current = current->next;
   }
   int myIndex = pos - prevSum;
   current->elements->erase(myIndex);
   return pos
}
/nat, insert, erase, operator[] etc. methods go here...
};

       
