#include <iostream>
#include <fstream>
#include <sstream>
#include <cstdlib>

#include"StockJAR.h"
#include"HeapJAR.h"
#include"ChainedHashTRP.h"

using std::ifstream;
using std::string;
using std::stringstream;
using std::vector;
using std::cout;
using std::endl;
using std::getline;

int main(int argc, char* argv[])
{
    if(argc > 1)
    { //--- As per mahmood, instantiating all heaps and hash.
        ChainedHash<Stock> table;
        Heap<Proxy_byVolume> heap_byVolume;
        Heap<Proxy_byPercentUp> heap_byPercentUp;
        Heap<Proxy_byPercentDown> heap_byPercentDown;
        Heap<Proxy_byPercentChange> heap_byPercentChange;
        Heap<Proxy_byMomentum> heap_byMomentum;
        Heap<Proxy_byTrend> heap_byTrend;
        Heap<Proxy_byTicker> heap_byTicker;
	//--- instantiates items for command processing.
        ifstream fin(argv[1]);
        string line;
        stringstream ss;
        string cmdarg;
        string price;
        string shares;
        string stockname;
        string value;
	//--- while it is not the end of the file.
        while(!fin.eof())
        {//--- while the file still has lines.
            while(getline(fin, line))
            {//--- send line to a stringsream.
                ss << line;		
		//---Process the lines as per mahmood's email.
                while(getline(ss, cmdarg, ' '))
                {
                    if(cmdarg == "add?")
                    {
                        while(getline(ss, stockname, ' ')) 
                        {
                            while(getline(ss, shares, 's'))
                            {
                                size_t s = atoi(shares.c_str());
				while(getline(ss, price))
                                {
                                    double p = strtod(price.c_str(), NULL);
				    Stock stock(stockname, s, p);
                                    Stock* stock_ptr = &*table.insert(stock);
                                    heap_byVolume.push(stock_ptr);
                                    heap_byPercentUp.push(stock_ptr);
                                    heap_byPercentDown.push(stock_ptr);
                                    heap_byPercentChange.push(stock_ptr);
                                    heap_byMomentum.push(stock_ptr);
                                    heap_byTrend.push(stock_ptr);
                                    heap_byTicker.push(stock_ptr);	
                                }
                            }
                        }
                    }
                    else if(cmdarg == "printAll?")
                    { cout << endl << "Printing All" << endl;

                            heap_byTicker.make_heap();
				vector<Proxy_byTicker> top;
                            for(size_t i = heap_byTicker.size(); 0 < i; i--)
                            {
                                top.push_back(heap_byTicker.pop());
                                const Stock& stock = *top[top.size()-1];
				cout << stock.toString() << endl;
                            }
                            for(size_t i = 0; i < top.size(); i++)
                            {
                                heap_byTicker.push(top[i]);
                            }
                    }
                    else if(cmdarg == "printTopByMomentum?")
                    { cout << endl << "Printing by Momentum" << endl; 
                        while(getline(ss, value, ' '))
                        {
                            size_t v = atoi(value.c_str());
                            heap_byMomentum.make_heap();
                            vector<Proxy_byMomentum> top;
                            for(size_t i = 0; ((i < v) && (heap_byMomentum.size())) >0; i++)
                            {
                                top.push_back(heap_byMomentum.pop());
                                const Stock& stock = *top[top.size()-1];
                                cout << stock.toString() << endl;
                            }
                            for(size_t i = 0; i < top.size(); i++)
                            {
                                heap_byMomentum.push(top[i]);
                            }
                        }
                    }
                    else if(cmdarg == "printTopByPercentChange?")
                    { cout << endl << "Printing By Percent Change" << endl;
                        while(getline(ss, value, ' '))
                        {
                            size_t v = atoi(value.c_str());
                            heap_byPercentChange.make_heap();
                            vector<Proxy_byPercentChange> top;
                            for(size_t i = 0; ((i < v) && (heap_byPercentChange.size())) >0; i++)
                            {
                                top.push_back(heap_byPercentChange.pop());
                                const Stock& stock = *top[top.size()-1];
                                cout << stock.toString() << endl;
                            }
                            for(size_t i = 0; i < top.size(); i++)
                            {
                                heap_byPercentChange.push(top[i]);
                            }
                        }
                    }
                    else if(cmdarg == "printTopByPercentDown?")
                    { cout << endl << "Printing By Percent Down" << endl;
                        while(getline(ss, value, ' '))
                        {
                            size_t v = atoi(value.c_str());
                            heap_byPercentDown.make_heap();
                            vector<Proxy_byPercentDown> top;
                            for(size_t i = 0; ((i < v) && (heap_byPercentDown.size())) >0; i++)
                            {
                                top.push_back(heap_byPercentDown.pop());
                                const Stock& stock = *top[top.size()-1];
                                cout << stock.toString() << endl;
                            }
                            for(size_t i = 0; i < top.size(); i++)
                            {
                                heap_byPercentDown.push(top[i]);
                            }
                        }
                    }
                    else if(cmdarg == "printTopByPercentUp?")
                    { cout << endl << "Printing By Percent Up" << endl;
                        while(getline(ss, value, ' '))
                        {
                            size_t v = atoi(value.c_str());
                            heap_byPercentUp.make_heap();
                            vector<Proxy_byPercentUp> top;
                            for(size_t i = 0; ((i < v) && (heap_byPercentUp.size())) >0; i++)
                            {
                                top.push_back(heap_byPercentUp.pop());
                                const Stock& stock = *top[top.size()-1];
                                cout << stock.toString() << endl;
                            }
                            for(size_t i = 0; i < top.size(); i++)
                            {
                                heap_byPercentUp.push(top[i]);
                            }
                        }
                    }
                    else if(cmdarg == "printTopTrendTrades?")
                    { cout << endl << "Printing By Trend Trades" << endl;
                        while(getline(ss, value, ' '))
                        {
                            size_t v = atoi(value.c_str());
                            heap_byTrend.make_heap();
                            vector<Proxy_byTrend> top;
                            for(size_t i = 0; ((i < v) && (heap_byTrend.size())) >0; i++)
                            {
                                top.push_back(heap_byTrend.pop());
                                const Stock& stock = *top[top.size()-1];
                                cout << stock.toString() << endl;
                            }
                            for(size_t i = 0; i < top.size(); i++)
                            {
                                heap_byTrend.push(top[i]);
                            }
                        }
                    }
                    else if(cmdarg == "printTopByVolume?")
                    { cout << endl << "Printing By Volume" << endl;
                        while(getline(ss, value, ' '))
                        {
                            size_t v = atoi(value.c_str());
                            heap_byVolume.make_heap();
                            vector<Proxy_byVolume> top;
                            for(size_t i = 0; ((i < v) && (heap_byVolume.size())) >0; i++)
                            {
                                top.push_back(heap_byVolume.pop());
                                const Stock& stock = *top[top.size()-1];
                                cout << stock.toString() << endl;
                            }
                            for(size_t i = 0; i < top.size(); i++)
                            {
                                heap_byVolume.push(top[i]);
                            }
                        }
                    }
                    else
                    {
                        Stock* stock_ptr = &*table.find(cmdarg);
                        size_t ishares = atoi(shares.c_str());
                        double iprice = strtod(price.c_str(), NULL);
                        stock_ptr->process_trade(ishares, iprice);
                    }
                }//--- must clear the stream to restart and close once everything is done.
          ss.clear();  } 
        } fin.close();
    }return 0;
}

/* ------------------------------ QUESTIONS ---------------------------------------

 HEAPER:
                 
a) The heap stores proxy objects, not pointers.
b) My heap does not #include my parter's hash table it uses template classes in order to fetch the information.
c) The heap is not a heap all the time the heap is a heap whenever a object is added it makes a heap usinf fix_down
d) This heap in particular does not use function objects it utilizes proxy objects.
e) The stock uses proxy objects so it does not friend any objects.
f) The stock class processed transactions by utilizing the proxy objects for each particular type, while the stock does not parse the strings because the client will do that.
g) The stock class uses a method that processes the transactions in order to figure out the number of trades in the current upward or downward trend.
h) Hash only occurs when find or insert is called since it was easier to code compared to computing the hash code of the ticker symbol at construction time.

 HASHER:

a) The hash table stores values of I data or in my case, I item.
b) The hash table is allocated to the size of the bucket and hashes values according to standard java hash functions.
c) The dummy nodes were handeled via the data == NULL;
d) The dummy nodes stayed dummy nodes throughout.
e) The node was handled on end();
f) I tested the items for equality with an overloaded == operator which compared items.
g) Yes, any adjustments made for handeling specific item operators such as -> where taken care of and applied to those items.
h) Yes class invariants helped break down the code and ultimately restore the invariants at the end of the class for easier functionality.
*/
