#include<iostream>
#include<string>
#include"StackPairTRP.h"
#include<cstdlib>
#include<fstream>
#include<set>

using namespace std;

string wordTurn(const string& word){
    StackPairTRP<char>* ts = new StackPairTRP<char> ((word.length() * 2));
    int l;
    int r;
    l = 0;
    r = word.length();

    if (word.length() % 2 == 1) {
        ts->pushFront(word.at(word.length() / 2));
    }

    while (l < word.length() / 2) {
        ts->pushFront(word.at(l++));
        ts->pushRear(word.at(--r));
    }
    stringstream out;
    while(!ts->isEmpty()){
        out << ts->popFront();
    }
    return out.str();
}

bool binsearch(const vector<string>& words, const string& word){
cout << "starting point of binsearch" << endl;
    string turnedWord = wordTurn(word);
    int first = 0;
    int last = words.size() -1;
    if (last<first) {
        return false;
    }
    if(word.length() > 3){
    while (first<=last) { //REQ: The first index must be less than the last index
        int middle = (first+last)/2;
        int comp = turnedWord.compare(words[middle]);
        if(comp==0) { //REQ: Assures words are same.
            return true;
        }
        if(comp>0) {
            first = middle + 1;
        }
        if(comp<0){
                last = middle -1;
            }
        }
    return false;
    }
}

int main (int argc, char* argv[]){
    if (argc == 1){ //REQ: If there is only 1 argc, then no input has been given.
        cout << "No input file included." << endl;
        return 0;
    }
    vector<string> tw;
    ifstream fin(argv[1]);
    ofstream pair;
    pair.open("pair.txt");
    string line;

    if(fin.is_open()){          //REQ: If the file is open, proceeds with operation.
        while (!fin.eof()){         //LOOP INV: Continues loops until end of file.
                getline(fin,line);
                tw.push_back(line);

                if(binsearch(tw,line)){ //REQ: Adds word to pair.txt once binsearch determines that it exists in file.
                pair << line << endl;

        }
    }
        //ENS: When possible, the loop takes the strings from the inputed file,
        //turns it, and checks to see if it exists in the inputed file.

        fin.close();
        pair.close();
    }

    else
        cout <<"There is no input file." << endl;
    return 0;
}

//REPORT QUESTIONS:
//The three methods described runs at O(logn) times because 
//the methods limit the use of loops and iterate more efficiently.
// a - Binary search would still be more efficient since it 
// uses O(logn) thus out performing linear O(1)
// b - Binary search, once again, promises O(logn) and 
// the wordTurnAll method would substantially outperform the 
// vector tw method that has to sequentially read and write.
