/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Components;

//an import statement means I can refer to a class as if I specified the
//whole package
import javax.swing.JFileChooser;

/**
 * A simple file dialog box.  Use this when you want the user to choose
 * a file in a directory on your system.
 *
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/JFileChooser.html">javax.swing.JFileChooser</a>
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public class FileDialog extends JFileChooser implements NGP.Component {

  /** This container allows the Dialog to show itself */
  private NGP.Container _container;

  /**
   * The constructor where no default directory is specified.
   *
   * @param container the container that this should show above;
   * this will remain hidden until asked to {@link #appear() appear}
   * Note: This container cannot be an NGP.Contaiers.Frame
   * @param acceptText the text to put on the button that the user should
   * click on when they have found the right file
   */
  public FileDialog(NGP.Container container, String acceptText) {
    super();

    _container = container;
    this.setApproveButtonText(acceptText);
  }

  /**
   * The construcor where the default directory is specified.
   *
   * @param container the container that this should show above;
   * this will remain hidden until asked to {@link #appear() appear}
   * Note: This container cannot be an NGP.Containers.Frame
   * @param acceptText the text to put on the button that the user should
   * click on when they have found the right file
   * @param defaultDirectory the string pointing to the directory where the
   * dialog should start
   */
  public FileDialog(NGP.Container container, String acceptText,
		    String defaultDirectory) {
    //for some reason passing the defaultDirectory to the superclass
    //constructor does not seem to work.  i got a NullPointerException.
    //using setCurrentDirectory seems to work though.

    super();

    this.setCurrentDirectory(new java.io.File(defaultDirectory));

    _container = container;
    this.setApproveButtonText(acceptText);
  }


  /**
   * Call this method to make the file dialog box appear. Once the
   * user chooses a file, either
   * {@link #approvePressed(java.io.File) approvePressed}
   * or {@link #cancelPressed() cancelPressed} will be automatically called.
   */
  public void appear() {
//     int val = this.showDialog((javax.swing.JComponent)_container, null);
// Modified by PRV, 9/15/02 to allow FileDialog to be used with applets.    
    int val = this.showDialog((java.awt.Component)_container, null);

    if (val == JFileChooser.APPROVE_OPTION)
      this.approvePressed(this.getSelectedFile());
    else
      this.cancelPressed();
  }


  /**
   * Called when the user chooses a file.  Must be overridden to do something
   * useful.
   * @param file this will be the file that the user selected
   */
  public void approvePressed(java.io.File file) { }

  /**
   * Called when the Cancel button is pressed.  Override if you want something
   * special to happen if the user chooses cancel.  If you want to just
   * continue you don't need to do anything.
   */
  public void cancelPressed() { }

  /**
   * Set the preferred dimensions of this Component.
   *
   * @param d the <code>Dimension</code> for this <code>Component</code>.
   * @see #getDimension() getDimension
   */
  public void setDimension(java.awt.Dimension d) {
    this.setPreferredSize(d);
  }

  /**
   * Get the preferred dimensions of this Component.
   *
   * @return the preferred <code>Dimension</code> of this
   * <code>Component</code>.
   * @see #setDimension(java.awt.Dimension) setDimension
   */
  public java.awt.Dimension getDimension() {
    return this.getPreferredSize();
  }

}
