/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Components;

import javax.swing.JMenu;


/**
  * A menu that holds NGP.Components.MenuItem objects.  It is a subclass of 
  * the Swing JMenu class. Menu objects are contained by NGP.Components.MenuBar
  * objects.  To put a Menu on a MenuBar, just pass the MenuBar object to the
  * the Menu's constructor.
  *
  * Notice that the Swing JMenu class is a subclass of the Swing JMenuItem 
  * class.  This allows the programmer to have submenus by putting an 
  * NGP.Components.Menu object onto another NGP.Components.Menu object as a 
  * menu item.
  *
  * @see NGP.Components.MenuBar
  * @see NGP.Components.MenuItem
  * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/JMenu.html">javax.swing.JMenu</a>
  *
  * @author Brent Shields (<a href="mailto:bshields@cs.brown.edu">bshields</a>)
  */

public class Menu extends JMenu implements NGP.Component {

  /**
    * Create the menu on a menu bar.
    *
    * @param bar the menu bar on which this menu will appear
    * @param name the string that will appear on the menu bar as the name of this menu
    */
  public Menu(NGP.Components.MenuBar bar, String name) {
    super(name);
    
    bar.add(this);

    //without this line, the menu will be hidden by other components
    //this.getPopupMenu().setLightWeightPopupEnabled(false);
  }

  /**
    * Create the menu nested within another menu.
    *
    * @param menu the menu in which this menu will be nested.
    * @param name the string that will appear on the other menu as the name of this menu
    */
  public Menu(NGP.Components.Menu menu, String name) {
    super(name);

    menu.add(this);

    //without this line, the menu will be hidden by other components
    //this.getPopupMenu().setLightWeightPopupEnabled(false);
  }

  /**
    * Set the preferred dimensions of this Component.
    *
    * @param d the <code>Dimension</code> for this <code>Component</code>.
    * @see #getDimension() getDimension
    */
  public void setDimension(java.awt.Dimension d) {
    this.setPreferredSize(d);
  }

  /**
    * Get the preferred dimensions of this Component.
    *
    * @return the preferred <code>Dimension</code> of this
    * <code>Component</code>.
    * @see #setDimension(java.awt.Dimension) setDimension
    */
  public java.awt.Dimension getDimension() {
    return this.getPreferredSize();
  }
}
